/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.msc.service.ServiceController;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.AbstractBundleState;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.FrameworkEventsPlugin;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.HostBundleContext;
import org.jboss.osgi.framework.internal.HostBundleRevision;
import org.jboss.osgi.framework.internal.LazyActivationTracker;
import org.jboss.osgi.framework.internal.ModuleActivatorBridge;
import org.jboss.osgi.framework.internal.ServiceState;
import org.jboss.osgi.framework.internal.StartLevelPlugin;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.metadata.ActivationPolicyMetaData;
import org.jboss.osgi.modules.ModuleActivator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;
import org.osgi.service.resolver.ResolutionException;

final class HostBundleState
extends UserBundleState {
    private final Semaphore activationSemaphore = new Semaphore(1);
    private final AtomicBoolean alreadyStarting = new AtomicBoolean();
    private final AtomicBoolean awaitLazyActivation = new AtomicBoolean();
    private BundleActivator bundleActivator;

    HostBundleState(FrameworkState frameworkState, long bundleId, Deployment dep) {
        super(frameworkState, bundleId, dep);
    }

    static HostBundleState assertBundleState(Bundle bundle2) {
        AbstractBundleState bundleState = AbstractBundleState.assertBundleState(bundle2);
        assert (bundleState instanceof HostBundleState) : "Not a HostBundleState: " + bundleState;
        return (HostBundleState)bundleState;
    }

    @Override
    void initLazyActivation() {
        this.awaitLazyActivation.set(this.isActivationLazy());
    }

    @Override
    HostBundleContext createContextInternal() {
        return new HostBundleContext(this);
    }

    @Override
    HostBundleRevision createRevisionInternal(Deployment dep) throws BundleException {
        return new HostBundleRevision(this, dep);
    }

    @Override
    public BundleContext getBundleContext() {
        return super.getBundleContext();
    }

    @Override
    boolean isFragment() {
        return false;
    }

    int getStartLevel() {
        return this.getStorageState().getStartLevel();
    }

    void setStartLevel(int level) {
        FrameworkLogger.LOGGER.debugf("Setting bundle start level %d for: %s", level, this);
        BundleStoragePlugin.InternalStorageState storageState = this.getStorageState();
        storageState.setStartLevel(level);
    }

    @Override
    HostBundleRevision getCurrentBundleRevision() {
        return (HostBundleRevision)super.getCurrentBundleRevision();
    }

    boolean isPersistentlyStarted() {
        BundleStoragePlugin.InternalStorageState storageState = this.getStorageState();
        return storageState.isPersistentlyStarted();
    }

    boolean isActivationLazy() {
        ActivationPolicyMetaData activationPolicy = this.getActivationPolicy();
        String policyType = activationPolicy != null ? activationPolicy.getType() : null;
        return "lazy".equals(policyType);
    }

    ActivationPolicyMetaData getActivationPolicy() {
        return this.getOSGiMetaData().getBundleActivationPolicy();
    }

    boolean awaitLazyActivation() {
        return this.awaitLazyActivation.get();
    }

    void activateLazily() throws BundleException {
        if (this.awaitLazyActivation.getAndSet(false) && this.startLevelValidForStart()) {
            int options = 1;
            if (this.isBundleActivationPolicyUsed()) {
                options |= 2;
            }
            FrameworkLogger.LOGGER.debugf("Lazy activation of: %s", this);
            this.startInternal(options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        LazyActivationTracker.startTracking(this, className);
        try {
            Class<?> loadedClass = super.loadClass(className);
            LazyActivationTracker.processLoadedClass(loadedClass);
            Class<?> clazz = loadedClass;
            return clazz;
        }
        finally {
            LazyActivationTracker.stopTracking(this, className);
        }
    }

    private boolean startLevelValidForStart() {
        StartLevelPlugin startLevelPlugin = this.getCoreServices().getStartLevel();
        return this.getStartLevel() <= startLevelPlugin.getStartLevel();
    }

    private boolean isBundleActivationPolicyUsed() {
        BundleStoragePlugin.InternalStorageState storageState = this.getStorageState();
        return storageState.isBundleActivationPolicyUsed();
    }

    private void setBundleActivationPolicyUsed(boolean usePolicy) {
        BundleStoragePlugin.InternalStorageState storageState = this.getStorageState();
        storageState.setBundleActivationPolicyUsed(usePolicy);
    }

    boolean isAlreadyStarting() {
        return this.alreadyStarting.get();
    }

    Set<UserBundleState> getDependentBundles() {
        HashSet<UserBundleState> result = new HashSet<UserBundleState>();
        if (this.isResolved()) {
            BundleWiring wiring = this.getCurrentBundleRevision().getWiring();
            List wires = wiring.getRequiredResourceWires(null);
            for (Wire wire : wires) {
                Resource provider = wire.getProvider();
                AbstractBundleState bundleState = ((AbstractBundleRevision)provider).getBundleState();
                if (!(bundleState instanceof UserBundleState)) continue;
                result.add((UserBundleState)bundleState);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void startInternal(int options) throws BundleException {
        this.assertStartConditions();
        FrameworkLogger.LOGGER.debugf("Starting bundle: %s", this);
        if (!this.startLevelValidForStart()) {
            if ((options & 1) != 0) {
                throw FrameworkMessages.MESSAGES.bundleCannotStartBundleDueToStartLevel();
            }
            FrameworkLogger.LOGGER.debugf("Start level [%d] not valid for: %s", this.getStartLevel(), this);
            this.persistAutoStartSettings(options);
            return;
        }
        this.alreadyStarting.set(true);
        try {
            boolean useActivationPolicy;
            this.aquireActivationLock();
            if (this.getState() == 32) {
                return;
            }
            this.persistAutoStartSettings(options);
            ResolutionException resex = this.ensureResolved(true);
            if (resex != null) {
                throw FrameworkMessages.MESSAGES.bundleCannotResolveBundle(resex, this);
            }
            if (this.getBundleContextInternal() == null) {
                this.createBundleContext();
            }
            boolean bl = useActivationPolicy = (options & 2) != 0;
            if (this.awaitLazyActivation.get() && useActivationPolicy) {
                this.transitionToStarting(options);
            } else {
                this.transitionToActive(options);
            }
        }
        finally {
            this.alreadyStarting.set(false);
            this.releaseActivationLock();
        }
    }

    private void assertStartConditions() throws BundleException {
        List requiredEnvs = this.getOSGiMetaData().getRequiredExecutionEnvironment();
        if (requiredEnvs != null) {
            boolean foundSupportedEnv = false;
            String frameworkEnvProp = (String)this.getBundleManager().getProperty("org.osgi.framework.executionenvironment");
            List<String> availableEnvs = Arrays.asList(frameworkEnvProp.split("[,\\s]+"));
            for (String aux : requiredEnvs) {
                if (!availableEnvs.contains(aux)) continue;
                foundSupportedEnv = true;
                break;
            }
            if (!foundSupportedEnv) {
                throw FrameworkMessages.MESSAGES.bundleUnsupportedExecutionEnvironment(requiredEnvs, availableEnvs);
            }
        }
    }

    private void persistAutoStartSettings(int options) {
        if ((options & 1) == 0) {
            this.setPersistentlyStarted(true);
            boolean activationPolicyUsed = (options & 2) != 0;
            this.setBundleActivationPolicyUsed(activationPolicyUsed);
        }
    }

    private void setPersistentlyStarted(boolean started) {
        BundleStoragePlugin.InternalStorageState storageState = this.getStorageState();
        storageState.setPersistentlyStarted(started);
    }

    private void transitionToStarting(int options) throws BundleException {
        if (this.getState() == 8) {
            return;
        }
        this.changeState(8, 512);
    }

    private void transitionToActive(int options) throws BundleException {
        block12: {
            try {
                this.changeState(8);
            }
            catch (LifecycleInterceptorException ex) {
                throw FrameworkMessages.MESSAGES.bundleCannotTransitionToStarting(ex, this);
            }
            String className = this.getOSGiMetaData().getBundleActivator();
            if (className != null) {
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                try {
                    Thread.currentThread().setContextClassLoader(null);
                    Object result = this.loadClass(className).newInstance();
                    if (result instanceof ModuleActivator) {
                        this.bundleActivator = new ModuleActivatorBridge((ModuleActivator)result);
                        this.bundleActivator.start(this.getBundleContext());
                        break block12;
                    }
                    if (result instanceof BundleActivator) {
                        this.bundleActivator = (BundleActivator)result;
                        this.bundleActivator.start(this.getBundleContext());
                        break block12;
                    }
                    throw FrameworkMessages.MESSAGES.bundleInvalidBundleActivator(className);
                }
                catch (Throwable th) {
                    this.changeState(16);
                    this.removeServicesAndListeners();
                    this.destroyBundleContext();
                    this.changeState(4);
                    if (th instanceof BundleException) {
                        throw (BundleException)th;
                    }
                    throw FrameworkMessages.MESSAGES.bundleCannotStartBundle(th, this);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(tccl);
                }
            }
        }
        if (this.getState() == 1) {
            throw FrameworkMessages.MESSAGES.bundleBundleUninstalledDuringActivatorStart(this);
        }
        this.changeState(32);
        this.getBundleManager().setServiceMode(this.getServiceName(32), ServiceController.Mode.ACTIVE);
        FrameworkLogger.LOGGER.infoBundleStarted(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void stopInternal(int options) throws BundleException {
        try {
            int priorState;
            this.aquireActivationLock();
            if (this.getState() == 1) {
                return;
            }
            if ((options & 1) == 0) {
                this.setPersistentlyStarted(false);
                this.setBundleActivationPolicyUsed(false);
            }
            if ((priorState = this.getState()) != 8 && priorState != 32) {
                return;
            }
            this.changeState(16);
            Throwable rethrow = null;
            if (priorState == 32 && this.bundleActivator != null) {
                try {
                    if (this.bundleActivator instanceof ModuleActivatorBridge) {
                        this.bundleActivator.stop(this.getBundleContext());
                    } else {
                        this.bundleActivator.stop(this.getBundleContext());
                    }
                }
                catch (Throwable t) {
                    rethrow = t;
                }
            }
            this.removeServicesAndListeners();
            if (this.getState() == 1) {
                throw FrameworkMessages.MESSAGES.bundleBundleUninstalledDuringActivatorStop(this);
            }
            this.destroyBundleContext();
            this.changeState(4, 4);
            this.getBundleManager().setServiceMode(this.getServiceName(32), ServiceController.Mode.NEVER);
            FrameworkLogger.LOGGER.infoBundleStopped(this);
            if (rethrow != null) {
                throw FrameworkMessages.MESSAGES.bundleErrorDuringActivatorStop(rethrow, this);
            }
        }
        finally {
            this.releaseActivationLock();
        }
    }

    private void aquireActivationLock() throws BundleException {
        try {
            FrameworkLogger.LOGGER.tracef("Aquire activation lock: %s", this);
            if (!this.activationSemaphore.tryAcquire(10L, TimeUnit.SECONDS)) {
                throw FrameworkMessages.MESSAGES.bundleCannotAcquireStartStopLock(this);
            }
        }
        catch (InterruptedException ex) {
            FrameworkLogger.LOGGER.debugf("Interupted while trying to start/stop bundle: %s", this);
            return;
        }
    }

    private void releaseActivationLock() {
        FrameworkLogger.LOGGER.tracef("Release activation lock: %s", this);
        this.activationSemaphore.release();
    }

    private void removeServicesAndListeners() {
        for (ServiceState serviceState : this.getRegisteredServicesInternal()) {
            serviceState.unregisterInternal();
        }
        FrameworkEventsPlugin eventsPlugin = this.getFrameworkState().getFrameworkEventsPlugin();
        eventsPlugin.removeBundleListeners(this);
    }
}

