/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.framework.FrameworkModuleProvider;
import org.jboss.osgi.framework.IntegrationServices;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.SystemPathsProvider;
import org.jboss.osgi.framework.internal.AbstractBundleService;
import org.jboss.osgi.framework.internal.BundleManagerPlugin;
import org.jboss.osgi.framework.internal.BundleStoragePlugin;
import org.jboss.osgi.framework.internal.FrameworkState;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.framework.internal.SystemBundleRevision;
import org.jboss.osgi.framework.internal.SystemBundleState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.metadata.OSGiMetaDataBuilder;
import org.jboss.osgi.resolver.XEnvironment;
import org.jboss.osgi.resolver.XResource;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;

public final class SystemBundleService
extends AbstractBundleService<SystemBundleState> {
    private final InjectedValue<SystemPathsProvider> injectedSystemPaths = new InjectedValue();
    private final InjectedValue<FrameworkModuleProvider> injectedModuleProvider = new InjectedValue();
    private final InjectedValue<BundleStoragePlugin> injectedBundleStorage = new InjectedValue();
    private final InjectedValue<XEnvironment> injectedEnvironmentPlugin = new InjectedValue();
    private SystemBundleState bundleState;

    static void addService(ServiceTarget serviceTarget, FrameworkState frameworkState) {
        SystemBundleService service = new SystemBundleService(frameworkState);
        ServiceBuilder builder = serviceTarget.addService(Services.SYSTEM_BUNDLE, (Service)service);
        builder.addDependency(Services.ENVIRONMENT, XEnvironment.class, service.injectedEnvironmentPlugin);
        builder.addDependency(IntegrationServices.FRAMEWORK_MODULE_PROVIDER, FrameworkModuleProvider.class, service.injectedModuleProvider);
        builder.addDependency(IntegrationServices.SYSTEM_PATHS_PROVIDER, SystemPathsProvider.class, service.injectedSystemPaths);
        builder.addDependency(InternalServices.BUNDLE_STORAGE_PLUGIN, BundleStoragePlugin.class, service.injectedBundleStorage);
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private SystemBundleService(FrameworkState frameworkState) {
        super(frameworkState);
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        try {
            this.bundleState = this.createBundleState();
            this.bundleState.changeState(8);
            OSGiMetaData metadata = this.createOSGiMetaData();
            SystemBundleRevision sysrev = this.bundleState.createBundleRevision(metadata);
            this.addToEnvironment(sysrev);
            this.bundleState.createBundleContext();
            this.bundleState.createStorageState((BundleStoragePlugin)((Object)this.injectedBundleStorage.getValue()));
            BundleManagerPlugin bundleManager = this.getBundleManager();
            bundleManager.injectedSystemBundle.inject((Object)this.bundleState);
        }
        catch (BundleException ex) {
            throw new StartException((Throwable)ex);
        }
    }

    SystemBundleState createBundleState() {
        return new SystemBundleState(this.getFrameworkState(), (FrameworkModuleProvider)this.injectedModuleProvider.getValue());
    }

    @Override
    SystemBundleState getBundleState() {
        return this.bundleState;
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        BundleManagerPlugin bundleManager = this.getBundleManager();
        bundleManager.injectedSystemBundle.uninject();
    }

    private OSGiMetaData createOSGiMetaData() {
        SystemBundleState bundleState = this.getBundleState();
        OSGiMetaDataBuilder builder = OSGiMetaDataBuilder.createBuilder((String)bundleState.getSymbolicName(), (Version)bundleState.getVersion());
        SystemPathsProvider systemPackages = (SystemPathsProvider)this.injectedSystemPaths.getValue();
        ArrayList<String> exportedPackages = new ArrayList<String>();
        exportedPackages.addAll(systemPackages.getSystemPackages());
        Iterator i$ = exportedPackages.iterator();
        while (i$.hasNext()) {
            String packageSpec;
            String packname = packageSpec = (String)i$.next();
            Version version = Version.emptyVersion;
            int versionIndex = packname.indexOf(";version=");
            if (versionIndex > 0) {
                packname = packageSpec.substring(0, versionIndex);
                version = Version.parseVersion((String)packageSpec.substring(versionIndex + 9));
            }
            builder.addExportPackages(new String[]{packname + ";version=" + version});
        }
        return builder.getOSGiMetaData();
    }

    private void addToEnvironment(SystemBundleRevision sysrev) {
        XEnvironment env = (XEnvironment)this.injectedEnvironmentPlugin.getValue();
        env.installResources(new XResource[]{sysrev});
    }
}

