/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jboss.modules.Module;
import org.jboss.osgi.deployment.deployer.Deployment;
import org.jboss.osgi.framework.StorageState;
import org.jboss.osgi.framework.internal.AbstractBundleRevision;
import org.jboss.osgi.framework.internal.EntriesProvider;
import org.jboss.osgi.framework.internal.FrameworkLogger;
import org.jboss.osgi.framework.internal.ModuleEntriesProvider;
import org.jboss.osgi.framework.internal.RevisionContent;
import org.jboss.osgi.framework.internal.UserBundleState;
import org.jboss.osgi.metadata.OSGiMetaData;
import org.jboss.osgi.vfs.AbstractVFS;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleException;

abstract class UserBundleRevision
extends AbstractBundleRevision {
    private final Deployment deployment;
    private List<RevisionContent> contentList;
    private final EntriesProvider entriesProvider;

    UserBundleRevision(UserBundleState userBundle, Deployment dep) throws BundleException {
        super(userBundle, UserBundleRevision.getOSGiMetaData(dep), UserBundleRevision.getRevisionId(dep));
        this.deployment = dep;
        if (dep.getRoot() != null) {
            this.contentList = this.getBundleClassPath(dep.getRoot(), this.getOSGiMetaData());
            this.entriesProvider = this.getRootContent();
        } else {
            Module module = (Module)dep.getAttachment(Module.class);
            this.entriesProvider = new ModuleEntriesProvider(module);
            this.contentList = Collections.emptyList();
            this.addAttachment(Module.class, module);
        }
    }

    private static OSGiMetaData getOSGiMetaData(Deployment dep) {
        return (OSGiMetaData)dep.getAttachment(OSGiMetaData.class);
    }

    private static int getRevisionId(Deployment dep) {
        StorageState storageState = (StorageState)dep.getAttachment(StorageState.class);
        return storageState.getRevisionId();
    }

    Deployment getDeployment() {
        return this.deployment;
    }

    @Override
    String getLocation() {
        return this.deployment.getLocation();
    }

    @Override
    UserBundleState getBundleState() {
        return (UserBundleState)super.getBundleState();
    }

    RevisionContent getRootContent() {
        return this.contentList.size() > 0 ? this.contentList.get(0) : null;
    }

    List<RevisionContent> getContentList() {
        return this.contentList;
    }

    RevisionContent getContentById(int contentId) {
        for (RevisionContent aux : this.contentList) {
            if (aux.getContentId() != contentId) continue;
            return aux;
        }
        return null;
    }

    void close() {
        for (RevisionContent aux : this.contentList) {
            aux.close();
        }
    }

    @Override
    Enumeration<String> getEntryPaths(String path) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.getEntryPaths(path);
    }

    @Override
    URL getEntry(String path) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.getEntry(path);
    }

    @Override
    Enumeration<URL> findEntries(String path, String pattern, boolean recurse) {
        this.getBundleState().assertNotUninstalled();
        return this.entriesProvider.findEntries(path, pattern, recurse);
    }

    private List<RevisionContent> getBundleClassPath(VirtualFile rootFile, OSGiMetaData metadata) {
        assert (rootFile != null) : "Null rootFile";
        if (metadata.getBundleClassPath().size() == 0) {
            RevisionContent revContent = new RevisionContent(this, 0, rootFile);
            return Collections.singletonList(revContent);
        }
        ArrayList<RevisionContent> rootList = new ArrayList<RevisionContent>();
        for (String path : metadata.getBundleClassPath()) {
            if (path.equals(".")) {
                RevisionContent revContent = new RevisionContent(this, rootList.size(), rootFile);
                rootList.add(revContent);
                continue;
            }
            try {
                VirtualFile child = rootFile.getChild(path);
                if (child == null) continue;
                VirtualFile anotherRoot = AbstractVFS.toVirtualFile((URL)child.toURL());
                RevisionContent revContent = new RevisionContent(this, rootList.size(), anotherRoot);
                rootList.add(revContent);
            }
            catch (IOException ex) {
                FrameworkLogger.LOGGER.errorCannotGetClassPathEntry(ex, path, this);
            }
        }
        return Collections.unmodifiableList(rootList);
    }
}

