/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.osgi.framework.internal;

import java.util.Set;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jboss.osgi.deployment.interceptor.AbstractLifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.InvocationContext;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptor;
import org.jboss.osgi.deployment.interceptor.LifecycleInterceptorException;
import org.jboss.osgi.framework.Services;
import org.jboss.osgi.framework.internal.AbstractPluginService;
import org.jboss.osgi.framework.internal.FrameworkMessages;
import org.jboss.osgi.framework.internal.InternalServices;
import org.jboss.osgi.vfs.VirtualFile;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

final class WebXMLVerifierInterceptor
extends AbstractPluginService<WebXMLVerifierInterceptor>
implements LifecycleInterceptor {
    private final InjectedValue<BundleContext> injectedSystemContext = new InjectedValue();
    private LifecycleInterceptor delegate;
    private ServiceRegistration registration;

    static void addService(ServiceTarget serviceTarget) {
        WebXMLVerifierInterceptor service = new WebXMLVerifierInterceptor();
        ServiceBuilder builder = serviceTarget.addService(InternalServices.WEBXML_VERIFIER_PLUGIN, (Service)service);
        builder.addDependency(Services.SYSTEM_CONTEXT, BundleContext.class, service.injectedSystemContext);
        builder.addDependencies(new ServiceName[]{Services.FRAMEWORK_CREATE, InternalServices.LIFECYCLE_INTERCEPTOR_PLUGIN});
        builder.setInitialMode(ServiceController.Mode.ON_DEMAND);
        builder.install();
    }

    private WebXMLVerifierInterceptor() {
    }

    @Override
    public void start(StartContext context) throws StartException {
        super.start(context);
        this.delegate = new AbstractLifecycleInterceptor(){

            public void invoke(int state, InvocationContext context) throws LifecycleInterceptorException {
                if (state == 8) {
                    try {
                        VirtualFile root = context.getRoot();
                        if (root != null) {
                            boolean isWebApp;
                            VirtualFile webXML = root.getChild("/WEB-INF/web.xml");
                            String contextPath = (String)context.getBundle().getHeaders().get("Web-ContextPath");
                            boolean bl = isWebApp = contextPath != null || root.getName().endsWith(".war");
                            if (isWebApp && webXML == null) {
                                throw FrameworkMessages.MESSAGES.lifecycleInterceptorCannotObtainWebXML(root.toURL());
                            }
                        }
                    }
                    catch (RuntimeException rte) {
                        throw rte;
                    }
                    catch (Exception ex) {
                        throw FrameworkMessages.MESSAGES.lifecycleInterceptorCannotObtainWebXML(ex);
                    }
                }
            }
        };
        BundleContext systemContext = (BundleContext)this.injectedSystemContext.getValue();
        this.registration = systemContext.registerService(LifecycleInterceptor.class.getName(), (Object)this.delegate, null);
    }

    @Override
    public void stop(StopContext context) {
        super.stop(context);
        this.registration.unregister();
        this.delegate = null;
        this.registration = null;
    }

    public WebXMLVerifierInterceptor getValue() {
        return this;
    }

    public Set<Class<?>> getInput() {
        return this.delegate.getInput();
    }

    public Set<Class<?>> getOutput() {
        return this.delegate.getOutput();
    }

    public int getRelativeOrder() {
        return this.delegate.getRelativeOrder();
    }

    public void invoke(int state, InvocationContext context) throws LifecycleInterceptorException {
        this.delegate.invoke(state, context);
    }
}

