/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.pc.controller.impl.state;

import java.util.Map;
import javax.xml.namespace.QName;
import org.gatein.common.util.ParameterMap;
import org.gatein.pc.api.info.NavigationInfo;
import org.gatein.pc.api.info.ParameterInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.controller.ControllerContext;
import org.gatein.pc.controller.state.PageNavigationalState;
import org.gatein.pc.controller.state.StateControllerContext;

public class StateControllerContextImpl
implements StateControllerContext {
    @Override
    public void updatePublicNavigationalState(ControllerContext controller, PageNavigationalState page, String portletWindowId, Map<String, String[]> update) {
        PortletInfo info = controller.getPortletInfo(portletWindowId);
        if (info != null) {
            NavigationInfo navigationInfo = info.getNavigation();
            for (Map.Entry<String, String[]> entry : update.entrySet()) {
                String id = entry.getKey();
                ParameterInfo parameterInfo = navigationInfo.getPublicParameter(id);
                if (parameterInfo == null) continue;
                QName name = parameterInfo.getName();
                String[] value = entry.getValue();
                if (value.length > 0) {
                    page.setPublicNavigationalState(name, value);
                    continue;
                }
                page.removePublicNavigationalState(name);
            }
        }
    }

    @Override
    public Map<String, String[]> getPublicWindowNavigationalState(ControllerContext controller, PageNavigationalState page, String windowId) {
        PortletInfo info = controller.getPortletInfo(windowId);
        if (info != null) {
            ParameterMap publicNavigationalState = new ParameterMap();
            for (ParameterInfo parameterInfo : info.getNavigation().getPublicParameters()) {
                String[] parameterValue = page.getPublicNavigationalState(parameterInfo.getName());
                if (parameterValue == null) continue;
                String parameterId = parameterInfo.getId();
                publicNavigationalState.put((Object)parameterId, parameterValue.clone());
            }
            return publicNavigationalState;
        }
        return null;
    }
}

