/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security.vault;

import java.io.Console;
import java.util.Scanner;
import org.jboss.as.security.vault.VaultInteractiveSession;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;

public class VaultInteraction {
    private SecurityVault vault;
    private byte[] handshakeKey;

    public VaultInteraction(SecurityVault vault, byte[] handshakeKey) {
        this.vault = vault;
        this.handshakeKey = handshakeKey;
    }

    public void start() {
        Console console = System.console();
        if (console == null) {
            System.err.println("No console.");
            System.exit(1);
        }
        Scanner in = new Scanner(System.in);
        block8: while (true) {
            String commandStr = "Please enter a Digit::   0: Store a password  1: Check whether password exists  2: Exit";
            System.out.println(commandStr);
            int choice = in.nextInt();
            switch (choice) {
                case 0: {
                    System.out.println("Task:  Store a password");
                    char[] attributeValue = VaultInteractiveSession.getSensitiveValue("Please enter attribute value");
                    String vaultBlock = null;
                    while (vaultBlock == null || vaultBlock.length() == 0) {
                        vaultBlock = console.readLine("Enter Vault Block:", new Object[0]);
                    }
                    String attributeName = null;
                    while (attributeName == null || attributeName.length() == 0) {
                        attributeName = console.readLine("Enter Attribute Name:", new Object[0]);
                    }
                    try {
                        this.vault.store(vaultBlock, attributeName, attributeValue, this.handshakeKey);
                        String keyAsString = new String(this.handshakeKey);
                        System.out.println("Attribute Value for (" + vaultBlock + ", " + attributeName + ") saved");
                        System.out.println("                ");
                        System.out.println("Please make note of the following:");
                        System.out.println("********************************************");
                        System.out.println("Vault Block:" + vaultBlock);
                        System.out.println("Attribute Name:" + attributeName);
                        System.out.println("Shared Key:" + keyAsString);
                        System.out.println("Configuration should be done as follows:");
                        System.out.println("VAULT::" + vaultBlock + "::" + attributeName + "::" + keyAsString);
                        System.out.println("********************************************");
                        System.out.println("                ");
                    }
                    catch (SecurityVaultException e) {
                        System.out.println("Exception occurred:" + e.getLocalizedMessage());
                    }
                    continue block8;
                }
                case 1: {
                    String attributeName;
                    String vaultBlock;
                    System.out.println("Task: Verify whether a password exists");
                    try {
                        vaultBlock = null;
                        while (vaultBlock == null || vaultBlock.length() == 0) {
                            vaultBlock = console.readLine("Enter Vault Block:", new Object[0]);
                        }
                        attributeName = null;
                        while (attributeName == null || attributeName.length() == 0) {
                            attributeName = console.readLine("Enter Attribute Name:", new Object[0]);
                        }
                        if (!this.vault.exists(vaultBlock, attributeName)) {
                            System.out.println("No value has been store for (" + vaultBlock + ", " + attributeName + ")");
                            break;
                        }
                        System.out.println("A value exists for (" + vaultBlock + ", " + attributeName + ")");
                    }
                    catch (SecurityVaultException e) {
                        System.out.println("Exception occurred:" + e.getLocalizedMessage());
                    }
                    continue block8;
                }
                default: {
                    System.exit(0);
                }
            }
        }
    }
}

