/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.common.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public final class JarResource {
    public List<String> getJarContents(URL jarLocation) throws IOException {
        return this.getJarContents(jarLocation.openStream());
    }

    public List<String> getJarContents(InputStream is) throws IOException {
        return this.load(is);
    }

    public List<String> getJarContents(String jarLocation) throws IOException {
        return this.getJarContents(new File(jarLocation));
    }

    public List<String> getJarContents(File jarFile) throws IOException {
        return this.load(jarFile);
    }

    private List<String> load(File jarFile) throws IOException {
        ArrayList<String> jarContents = new ArrayList<String>();
        try {
            ZipFile zf = new ZipFile(jarFile);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory()) continue;
                jarContents.add(ze.getName());
            }
        }
        catch (NullPointerException e) {
            System.out.println("done.");
        }
        catch (ZipException ze) {
            ze.printStackTrace();
        }
        return jarContents;
    }

    private List<String> load(InputStream is) throws IOException {
        ArrayList<String> jarContents = new ArrayList<String>();
        try {
            ZipInputStream zis = new ZipInputStream(is);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (ze.isDirectory()) continue;
                jarContents.add(ze.getName());
                ze = zis.getNextEntry();
            }
        }
        catch (NullPointerException e) {
            System.out.println("done.");
        }
        return jarContents;
    }
}

