/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.helpers;

import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathUtils {
    private static XPathFactory xpathFactory = XPathFactory.newInstance();
    private XPath xpath = xpathFactory.newXPath();

    public XPathUtils() {
    }

    public XPathUtils(Map<String, String> ns) {
        this();
        if (ns != null) {
            this.xpath.setNamespaceContext(new MapNamespaceContext(ns));
        }
    }

    public XPathUtils(NamespaceContext ctx) {
        this();
        this.xpath.setNamespaceContext(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValue(String xpathExpression, Node node, QName type) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.xpath.getClass().getClassLoader());
            Object object = this.xpath.evaluate(xpathExpression, node, type);
            return object;
        }
        catch (Exception e) {
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    public NodeList getValueList(String xpathExpression, Node node) {
        return (NodeList)this.getValue(xpathExpression, node, XPathConstants.NODESET);
    }

    public String getValueString(String xpathExpression, Node node) {
        return (String)this.getValue(xpathExpression, node, XPathConstants.STRING);
    }

    public Node getValueNode(String xpathExpression, Node node) {
        return (Node)this.getValue(xpathExpression, node, XPathConstants.NODE);
    }

    public boolean isExist(String xpathExpression, Node node, QName type) {
        return this.getValue(xpathExpression, node, type) != null;
    }
}

