/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;

public class Types {
    private static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    public static boolean isA(Class clazz, ParameterizedType pType) {
        return clazz.isAssignableFrom((Class)pType.getRawType());
    }

    public static Class getArgumentType(ParameterizedType pType, int index) {
        return (Class)pType.getActualTypeArguments()[index];
    }

    public static Class getTemplateParameterOfInterface(Class base, Class desiredInterface) {
        Object rtn = Types.getSomething(base, desiredInterface);
        if (rtn != null && rtn instanceof Class) {
            return (Class)rtn;
        }
        return null;
    }

    private static Object getSomething(Class base, Class desiredInterface) {
        for (int i = 0; i < base.getInterfaces().length; ++i) {
            Class<?> intf = base.getInterfaces()[i];
            if (!intf.equals(desiredInterface)) continue;
            Type generic = base.getGenericInterfaces()[i];
            if (generic instanceof ParameterizedType) {
                ParameterizedType p = (ParameterizedType)generic;
                Type type = p.getActualTypeArguments()[0];
                Class<?> rtn = Types.getRawTypeNoException(type);
                if (rtn != null) {
                    return rtn;
                }
                return type;
            }
            return null;
        }
        if (base.getSuperclass() == null || base.getSuperclass().equals(Object.class)) {
            return null;
        }
        Object rtn = Types.getSomething(base.getSuperclass(), desiredInterface);
        if (rtn == null || rtn instanceof Class) {
            return rtn;
        }
        if (!(rtn instanceof TypeVariable)) {
            return null;
        }
        String name = ((TypeVariable)rtn).getName();
        int index = -1;
        TypeVariable<Class<T>>[] variables = base.getSuperclass().getTypeParameters();
        if (variables == null || variables.length < 1) {
            return null;
        }
        for (int i = 0; i < variables.length; ++i) {
            if (!variables[i].getName().equals(name)) continue;
            index = i;
        }
        if (index == -1) {
            return null;
        }
        Type genericSuperclass = base.getGenericSuperclass();
        if (!(genericSuperclass instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType pt = (ParameterizedType)genericSuperclass;
        Type type = pt.getActualTypeArguments()[index];
        Class<?> clazz = Types.getRawTypeNoException(type);
        if (clazz != null) {
            return clazz;
        }
        return type;
    }

    public static Type getGenericReturnTypeOfGenericInterfaceMethod(Class clazz, Method method) {
        if (!method.getDeclaringClass().isInterface()) {
            return method.getGenericReturnType();
        }
        try {
            Method tmp = clazz.getMethod(method.getName(), method.getParameterTypes());
            return tmp.getGenericReturnType();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return method.getGenericReturnType();
        }
    }

    public static boolean isCompatible(Method method, Method intfMethod) {
        if (method == intfMethod) {
            return true;
        }
        if (!method.getName().equals(intfMethod.getName())) {
            return false;
        }
        if (method.getParameterTypes().length != intfMethod.getParameterTypes().length) {
            return false;
        }
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Class<?> rootParam = method.getParameterTypes()[i];
            Class<?> intfParam = intfMethod.getParameterTypes()[i];
            if (intfParam.isAssignableFrom(rootParam)) continue;
            return false;
        }
        return true;
    }

    public static Method getImplementingMethod(Class clazz, Method intfMethod) {
        Class<?> declaringClass = intfMethod.getDeclaringClass();
        if (declaringClass.equals(clazz)) {
            return intfMethod;
        }
        Class<?>[] paramTypes = intfMethod.getParameterTypes();
        if (declaringClass.getTypeParameters().length > 0 && paramTypes.length > 0) {
            Type[] intfTypes = Types.findParameterizedTypes(clazz, declaringClass);
            HashMap<String, Type> typeVarMap = new HashMap<String, Type>();
            TypeVariable<Class<?>>[] vars = declaringClass.getTypeParameters();
            for (int i = 0; i < vars.length; ++i) {
                if (intfTypes != null && i < intfTypes.length) {
                    typeVarMap.put(vars[i].getName(), intfTypes[i]);
                    continue;
                }
                typeVarMap.put(vars[i].getName(), vars[i].getGenericDeclaration());
            }
            Type[] paramGenericTypes = intfMethod.getGenericParameterTypes();
            paramTypes = new Class[paramTypes.length];
            for (int i = 0; i < paramTypes.length; ++i) {
                if (paramGenericTypes[i] instanceof TypeVariable) {
                    TypeVariable tv = (TypeVariable)paramGenericTypes[i];
                    Type t = (Type)typeVarMap.get(tv.getName());
                    if (t == null) {
                        throw new RuntimeException("Unable to resolve type variable");
                    }
                    paramTypes[i] = Types.getRawType(t);
                    continue;
                }
                paramTypes[i] = Types.getRawType(paramGenericTypes[i]);
            }
        }
        try {
            return clazz.getMethod(intfMethod.getName(), paramTypes);
        }
        catch (NoSuchMethodException e) {
            try {
                Method tmp = clazz.getMethod(intfMethod.getName(), intfMethod.getParameterTypes());
                return tmp;
            }
            catch (NoSuchMethodException e2) {
                return intfMethod;
            }
        }
    }

    public static Class<?> getRawType(Type type) {
        TypeVariable typeVar;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Class<?> componentRawType = Types.getRawType(genericArrayType.getGenericComponentType());
            return Array.newInstance(componentRawType, 0).getClass();
        }
        if (type instanceof TypeVariable && (typeVar = (TypeVariable)type).getBounds() != null && typeVar.getBounds().length > 0) {
            return Types.getRawType(typeVar.getBounds()[0]);
        }
        throw new RuntimeException("Unable to determine base class from Type");
    }

    public static Class<?> getRawTypeNoException(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            return (Class)rawType;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Class<?> componentRawType = Types.getRawType(genericArrayType.getGenericComponentType());
            return Array.newInstance(componentRawType, 0).getClass();
        }
        return null;
    }

    public static Class<?> getTypeArgument(Type genericType) {
        if (!(genericType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType parameterizedType = (ParameterizedType)genericType;
        Class typeArg = (Class)parameterizedType.getActualTypeArguments()[0];
        return typeArg;
    }

    public static Class getCollectionBaseType(Class type, Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[0];
            return Types.getRawType(componentGenericType);
        }
        if (genericType instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)genericType;
            Type componentGenericType = genericArrayType.getGenericComponentType();
            return Types.getRawType(componentGenericType);
        }
        if (type.isArray()) {
            return type.getComponentType();
        }
        return null;
    }

    public static Class getMapKeyType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[0];
            return Types.getRawType(componentGenericType);
        }
        return null;
    }

    public static Class getMapValueType(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type componentGenericType = parameterizedType.getActualTypeArguments()[1];
            return Types.getRawType(componentGenericType);
        }
        return null;
    }

    public static Type getActualValueOfTypeVariable(Class<?> clazz, TypeVariable<?> typeVariable) {
        if (typeVariable.getGenericDeclaration() instanceof Class) {
            Class classDeclaringTypeVariable = (Class)typeVariable.getGenericDeclaration();
            Type fromInterface = Types.getTypeVariableViaGenericInterface(clazz, classDeclaringTypeVariable, typeVariable);
            if (fromInterface != null) {
                return fromInterface;
            }
            while (clazz.getSuperclass() != null) {
                if (clazz.getSuperclass().equals(classDeclaringTypeVariable)) {
                    ParameterizedType parameterizedSuperclass = (ParameterizedType)clazz.getGenericSuperclass();
                    for (int i = 0; i < classDeclaringTypeVariable.getTypeParameters().length; ++i) {
                        TypeVariable tv = classDeclaringTypeVariable.getTypeParameters()[i];
                        if (!tv.equals(typeVariable)) continue;
                        return parameterizedSuperclass.getActualTypeArguments()[i];
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
        throw new RuntimeException("Unable to determine value of type parameter " + typeVariable);
    }

    private static Type getTypeVariableViaGenericInterface(Class<?> clazz, Class<?> classDeclaringTypeVariable, TypeVariable<?> typeVariable) {
        for (Type genericInterface : clazz.getGenericInterfaces()) {
            if (genericInterface instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
                for (int i = 0; i < classDeclaringTypeVariable.getTypeParameters().length; ++i) {
                    TypeVariable<Class<?>> tv = classDeclaringTypeVariable.getTypeParameters()[i];
                    if (!tv.equals(typeVariable)) continue;
                    return parameterizedType.getActualTypeArguments()[i];
                }
                continue;
            }
            if (!(genericInterface instanceof Class)) continue;
            return Types.getTypeVariableViaGenericInterface((Class)genericInterface, classDeclaringTypeVariable, typeVariable);
        }
        return null;
    }

    public static Type[] getActualTypeArgumentsOfAnInterface(Class<?> classToSearch, Class<?> interfaceToFind) {
        for (Class<?> clazz = classToSearch; clazz != null; clazz = clazz.getSuperclass()) {
            for (Type genericInterface : clazz.getGenericInterfaces()) {
                if (!Types.getRawType(genericInterface).equals(interfaceToFind) || !(genericInterface instanceof ParameterizedType)) continue;
                return ((ParameterizedType)genericInterface).getActualTypeArguments();
            }
        }
        throw new RuntimeException("Unable to find type arguments of " + interfaceToFind);
    }

    public static Type[] findParameterizedTypes(Class<?> root, Class<?> searchedFor) {
        if (searchedFor.isInterface()) {
            return Types.findInterfaceParameterizedTypes(root, null, searchedFor);
        }
        return Types.findClassParameterizedTypes(root, null, searchedFor);
    }

    public static Type[] findClassParameterizedTypes(Class<?> root, ParameterizedType rootType, Class<?> searchedForClass) {
        Map<String, Type> typeVarMap = Types.populateParameterizedMap(root, rootType);
        Class<?> superclass = root.getSuperclass();
        Type genericSuper = root.getGenericSuperclass();
        if (superclass.equals(searchedForClass)) {
            return Types.extractTypes(typeVarMap, genericSuper);
        }
        if (genericSuper instanceof ParameterizedType) {
            ParameterizedType intfParam = (ParameterizedType)genericSuper;
            Type[] types = Types.findClassParameterizedTypes(superclass, intfParam, searchedForClass);
            if (types != null) {
                return Types.extractTypeVariables(typeVarMap, types);
            }
        } else {
            Type[] types = Types.findClassParameterizedTypes(superclass, null, searchedForClass);
            if (types != null) {
                return types;
            }
        }
        return null;
    }

    private static Map<String, Type> populateParameterizedMap(Class<?> root, ParameterizedType rootType) {
        HashMap<String, Type> typeVarMap = new HashMap<String, Type>();
        if (rootType != null) {
            TypeVariable<Class<?>>[] vars = root.getTypeParameters();
            for (int i = 0; i < vars.length; ++i) {
                typeVarMap.put(vars[i].getName(), rootType.getActualTypeArguments()[i]);
            }
        }
        return typeVarMap;
    }

    public static Type[] findInterfaceParameterizedTypes(Class<?> root, ParameterizedType rootType, Class<?> searchedForInterface) {
        int i;
        Map<String, Type> typeVarMap = Types.populateParameterizedMap(root, rootType);
        for (i = 0; i < root.getInterfaces().length; ++i) {
            Class<?> sub = root.getInterfaces()[i];
            Type genericSub = root.getGenericInterfaces()[i];
            if (!sub.equals(searchedForInterface)) continue;
            return Types.extractTypes(typeVarMap, genericSub);
        }
        for (i = 0; i < root.getInterfaces().length; ++i) {
            Class<?> sub;
            Type genericSub = root.getGenericInterfaces()[i];
            Type[] types = Types.recurseSuperclassForInterface(searchedForInterface, typeVarMap, genericSub, sub = root.getInterfaces()[i]);
            if (types == null) continue;
            return types;
        }
        if (root.isInterface()) {
            return null;
        }
        Class<?> superclass = root.getSuperclass();
        Type genericSuper = root.getGenericSuperclass();
        return Types.recurseSuperclassForInterface(searchedForInterface, typeVarMap, genericSuper, superclass);
    }

    private static Type[] recurseSuperclassForInterface(Class<?> searchedForInterface, Map<String, Type> typeVarMap, Type genericSub, Class<?> sub) {
        if (genericSub instanceof ParameterizedType) {
            ParameterizedType intfParam = (ParameterizedType)genericSub;
            Type[] types = Types.findInterfaceParameterizedTypes(sub, intfParam, searchedForInterface);
            if (types != null) {
                return Types.extractTypeVariables(typeVarMap, types);
            }
        } else {
            Type[] types = Types.findInterfaceParameterizedTypes(sub, null, searchedForInterface);
            if (types != null) {
                return types;
            }
        }
        return null;
    }

    private static Type[] extractTypeVariables(Map<String, Type> typeVarMap, Type[] types) {
        for (int j = 0; j < types.length; ++j) {
            if (types[j] instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)types[j];
                types[j] = typeVarMap.get(tv.getName());
                continue;
            }
            types[j] = types[j];
        }
        return types;
    }

    private static Type[] extractTypes(Map<String, Type> typeVarMap, Type genericSub) {
        if (genericSub instanceof ParameterizedType) {
            ParameterizedType param = (ParameterizedType)genericSub;
            Type[] types = param.getActualTypeArguments();
            Type[] returnTypes = new Type[types.length];
            System.arraycopy(types, 0, returnTypes, 0, types.length);
            Types.extractTypeVariables(typeVarMap, returnTypes);
            return returnTypes;
        }
        return EMPTY_TYPE_ARRAY;
    }

    public static class TypeInfo {
        private Class<?> type;
        private Type genericType;

        public TypeInfo(Class<?> type, Type genericType) {
            this.type = type;
            this.genericType = genericType;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Type getGenericType() {
            return this.genericType;
        }
    }
}

