/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http.interceptor;

import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.http.URIMapper;
import org.apache.cxf.binding.http.interceptor.DocumentWriterInterceptor;
import org.apache.cxf.binding.http.interceptor.URIParameterOutInterceptor;
import org.apache.cxf.binding.xml.interceptor.XMLMessageOutInterceptor;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.MessageSenderInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.interceptor.WrappedOutInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DatabindingOutSetupInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final WrappedOutInterceptor WRAPPED_OUT = new WrappedOutInterceptor();
    private static final XMLMessageOutInterceptor XML_OUT = new XMLMessageOutInterceptor();
    private static final StaxOutInterceptor STAX_OUT = new StaxOutInterceptor();

    public DatabindingOutSetupInterceptor() {
        super("pre-logical");
    }

    public void handleMessage(Message message) throws Fault {
        boolean client = Boolean.TRUE.equals(message.get((Object)"org.apache.cxf.client"));
        InterceptorChain chain = message.getInterceptorChain();
        if (client) {
            boolean putOrPost;
            Document document = DOMUtils.createDocument();
            message.setContent(Node.class, (Object)document);
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter(document);
            try {
                MapNamespaceContext nsMap = new MapNamespaceContext();
                nsMap.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
                writer.setNamespaceContext((NamespaceContext)nsMap);
            }
            catch (XMLStreamException e) {
                // empty catch block
            }
            message.setContent(XMLStreamWriter.class, (Object)writer);
            WrappedOutInterceptor wrappedOut = new WrappedOutInterceptor("pre-logical");
            wrappedOut.addAfter(this.getId());
            chain.add((Interceptor)wrappedOut);
            final XMLMessageOutInterceptor xmlOut = new XMLMessageOutInterceptor("pre-logical");
            xmlOut.addAfter(wrappedOut.getId());
            chain.add((Interceptor)xmlOut);
            Endpoint ep = (Endpoint)message.getExchange().get(Endpoint.class);
            URIMapper mapper = (URIMapper)ep.getService().get((Object)URIMapper.class.getName());
            BindingOperationInfo bop = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
            String verb = mapper.getVerb(bop);
            message.put((Object)"org.apache.cxf.request.method", (Object)verb);
            boolean bl = putOrPost = verb.equals("POST") || verb.equals("PUT");
            if (putOrPost) {
                chain.add((Interceptor)new URIParameterOutInterceptor());
                chain.add((Interceptor)new DocumentWriterInterceptor());
                chain.add((Interceptor)new AbstractPhaseInterceptor<Message>("remove-writer", "prepare-send"){
                    {
                        super(x0, x1);
                        this.addAfter(xmlOut.getId());
                        this.addBefore(MessageSenderInterceptor.class.getName());
                    }

                    public void handleMessage(Message message) throws Fault {
                        message.removeContent(XMLStreamWriter.class);
                    }
                });
                chain.add((Interceptor)STAX_OUT);
            } else {
                chain.add((Interceptor)new URIParameterOutInterceptor());
            }
        } else {
            chain.add((Interceptor)STAX_OUT);
            chain.add((Interceptor)WRAPPED_OUT);
            chain.add((Interceptor)XML_OUT);
        }
    }
}

