/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.http.strategy;

import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.http.URIMapper;
import org.apache.cxf.binding.http.strategy.EnglishInflector;
import org.apache.cxf.binding.http.strategy.Inflector;
import org.apache.cxf.binding.http.strategy.ResourceStrategy;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.ws.commons.schema.XmlSchemaElement;

public class ConventionStrategy
implements ResourceStrategy {
    private static final Logger LOG = LogUtils.getL7dLogger(ConventionStrategy.class);
    private Inflector inflector = new EnglishInflector();

    @Override
    public boolean map(BindingOperationInfo bop, Method m, URIMapper mapper) {
        String resource;
        String verb;
        boolean pluralize;
        String name = m.getName();
        BindingOperationInfo bopWithParts = bop.isUnwrappedCapable() ? bop.getUnwrappedOperation() : bop;
        boolean bl = pluralize = bopWithParts.getInput().getMessageParts().size() > 0;
        if (name.startsWith("get")) {
            verb = "GET";
            String noun = this.extractNoun(name, 3, pluralize);
            resource = this.createResourceName(noun, bopWithParts);
        } else if (name.startsWith("add")) {
            String noun;
            verb = "POST";
            resource = noun = this.extractNoun(name, 3, pluralize);
        } else if (name.startsWith("create")) {
            String noun;
            verb = "POST";
            resource = noun = this.extractNoun(name, 5, pluralize);
        } else if (name.startsWith("update")) {
            verb = "PUT";
            String noun = this.extractNoun(name, 6, pluralize);
            resource = this.createResourceName(noun, bopWithParts);
        } else if (name.startsWith("remove") || name.startsWith("delete")) {
            verb = "DELETE";
            String noun = this.extractNoun(name, 6, pluralize);
            resource = this.createResourceName(noun, bopWithParts);
        } else {
            String noun;
            verb = "POST";
            resource = noun = name;
        }
        resource = '/' + resource;
        LOG.info("Mapping method " + name + " to resource " + resource + " and verb " + verb);
        mapper.bind(bop, resource, verb);
        return true;
    }

    private String createResourceName(String noun, BindingOperationInfo bopWithParts) {
        StringBuilder builder = new StringBuilder();
        builder.append(noun);
        for (MessagePartInfo part : bopWithParts.getInput().getMessageParts()) {
            if (!this.isXSDPrimitive(part)) continue;
            builder.append("/{").append(part.getName().getLocalPart()).append("}");
        }
        return builder.toString();
    }

    private boolean isXSDPrimitive(MessagePartInfo part) {
        String xsdNs = "http://www.w3.org/2001/XMLSchema";
        QName tn = null;
        tn = part.isElement() ? ((XmlSchemaElement)part.getXmlSchema()).getSchemaTypeName() : part.getTypeQName();
        return tn != null && tn.getNamespaceURI().equals(xsdNs);
    }

    private String extractNoun(String name, int n, boolean pluralize) {
        name = name.substring(n, n + 1).toLowerCase() + name.substring(n + 1);
        if (pluralize) {
            name = this.inflector.pluralize(name);
        }
        return name;
    }

    public Inflector getInflector() {
        return this.inflector;
    }

    public void setInflector(Inflector inflector) {
        this.inflector = inflector;
    }
}

