/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.standalone;

import java.io.InputStream;
import java.util.concurrent.Future;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentActionResult;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentPlanResult;

public class ServerDeploymentHelper {
    private final ServerDeploymentManager deploymentManager;

    public ServerDeploymentHelper(ModelControllerClient client) {
        this.deploymentManager = ServerDeploymentManager.Factory.create(client);
    }

    public ServerDeploymentHelper(ServerDeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
    }

    public String deploy(String name, InputStream input) throws ServerDeploymentException {
        ServerDeploymentActionResult actionResult;
        String runtimeName;
        try {
            DeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            builder = builder.add(name, input).andDeploy();
            DeploymentPlan plan = builder.build();
            DeploymentAction action = builder.getLastAction();
            runtimeName = action.getDeploymentUnitUniqueName();
            Future<ServerDeploymentPlanResult> future = this.deploymentManager.execute(plan);
            ServerDeploymentPlanResult planResult = future.get();
            actionResult = planResult.getDeploymentActionResult(action.getId());
        }
        catch (Exception ex) {
            throw new ServerDeploymentException(ex);
        }
        if (actionResult.getDeploymentException() != null) {
            throw new ServerDeploymentException(actionResult);
        }
        return runtimeName;
    }

    public void undeploy(String runtimeName) throws ServerDeploymentException {
        ServerDeploymentActionResult actionResult;
        try {
            DeploymentPlanBuilder builder = this.deploymentManager.newDeploymentPlan();
            builder = builder.undeploy(runtimeName).remove(runtimeName);
            DeploymentPlan plan = builder.build();
            DeploymentAction action = builder.getLastAction();
            Future<ServerDeploymentPlanResult> future = this.deploymentManager.execute(plan);
            ServerDeploymentPlanResult planResult = future.get();
            actionResult = planResult.getDeploymentActionResult(action.getId());
        }
        catch (Exception ex) {
            throw new ServerDeploymentException(ex);
        }
        if (actionResult.getDeploymentException() != null) {
            throw new ServerDeploymentException(actionResult);
        }
    }

    public static class ServerDeploymentException
    extends Exception {
        private static final long serialVersionUID = 1L;
        private final ServerDeploymentActionResult actionResult;

        private ServerDeploymentException(ServerDeploymentActionResult actionResult) {
            super(actionResult.getDeploymentException());
            this.actionResult = actionResult;
        }

        private ServerDeploymentException(Throwable cause) {
            super(cause);
            this.actionResult = null;
        }

        public ServerDeploymentActionResult getActionResult() {
            return this.actionResult;
        }
    }
}

