/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.test;

import java.io.File;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.facesconfig21.WebFacesConfigDescriptor;
import org.jboss.shrinkwrap.descriptor.api.webapp30.WebAppDescriptor;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.jboss.shrinkwrap.resolver.api.maven.PomEquippedResolveStage;

public class TestDeployment {
    public static WebArchive createDeployment() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addAsLibraries(((MavenFormatStage)((MavenStrategyStage)((PomEquippedResolveStage)Maven.resolver().loadPomFromFile("pom.xml")).resolve("org.jboss.portletbridge:portletbridge-impl")).withTransitivity()).as(File.class));
    }

    public static WebArchive createDeploymentWithAll() {
        WebArchive archive = TestDeployment.createDeployment();
        TestDeployment.addWebXml(archive);
        TestDeployment.addFacesConfig(archive);
        TestDeployment.addPortletXml(archive);
        return archive;
    }

    public static WebArchive createDeploymentWithWebXmlAndPortletXml() {
        WebArchive archive = TestDeployment.createDeployment();
        TestDeployment.addWebXml(archive);
        TestDeployment.addPortletXml(archive);
        return archive;
    }

    public static WebArchive addWebXml(WebArchive archive) {
        return (WebArchive)archive.addAsWebInfResource("WEB-INF/web.xml", "web.xml");
    }

    public static WebArchive addFacesConfig(WebArchive archive) {
        return (WebArchive)archive.addAsWebInfResource("WEB-INF/faces-config.xml");
    }

    public static WebArchive addPortletXml(WebArchive archive) {
        return (WebArchive)archive.addAsWebInfResource("WEB-INF/portlet.xml", "portlet.xml");
    }

    public static WebAppDescriptor createWebXmlDescriptor() {
        WebAppDescriptor webConfig = (WebAppDescriptor)Descriptors.create(WebAppDescriptor.class);
        ((WebAppDescriptor)((WebAppDescriptor)webConfig.addDefaultNamespaces()).version("3.0").displayName(new String[]{"integrationTest"}).createServlet().servletName("Faces Servlet").servletClass("javax.faces.webapp.FacesServlet").loadOnStartup(Integer.valueOf(2)).up()).createServletMapping().servletName("Faces Servlet").urlPattern(new String[]{"*.jsf"}).up();
        return webConfig;
    }

    public static WebFacesConfigDescriptor createFacesConfigXmlDescriptor() {
        WebFacesConfigDescriptor facesConfig = (WebFacesConfigDescriptor)Descriptors.create(WebFacesConfigDescriptor.class);
        ((WebFacesConfigDescriptor)facesConfig.addDefaultNamespaces()).version("2.1");
        return facesConfig;
    }
}

