/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.JavaUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class NamespaceHelper {
    private NamespaceHelper() {
    }

    public static String getUniquePrefix(Element element, String namespaceURI) {
        String prefix = NamespaceHelper.getPrefix(element, namespaceURI);
        if (prefix == null) {
            if ("".equals(namespaceURI)) {
                return "";
            }
            prefix = DOMUtils.createNamespace((Element)element, (String)namespaceURI);
        }
        return prefix;
    }

    public static String getPrefix(Element element, String namespaceURI) {
        return DOMUtils.getPrefixRecursive((Element)element, (String)namespaceURI);
    }

    public static void getPrefixes(Element element, String namespaceURI, List<String> prefixes) {
        DOMUtils.getPrefixesRecursive((Element)element, (String)namespaceURI, prefixes);
    }

    public static String getUniquePrefix(XMLStreamWriter writer, String namespaceURI, boolean declare) throws XMLStreamException {
        return NamespaceHelper.getUniquePrefix(writer, namespaceURI, null, declare);
    }

    public static String getUniquePrefix(XMLStreamWriter writer, String namespaceURI, String preferred, boolean declare) throws XMLStreamException {
        String existing;
        if (preferred != null && namespaceURI.equals(existing = writer.getNamespaceContext().getNamespaceURI(preferred))) {
            return preferred;
        }
        String prefix = preferred;
        if (prefix == null && (prefix = writer.getNamespaceContext().getPrefix(namespaceURI)) != null) {
            declare = false;
        }
        if (prefix == null) {
            prefix = StaxUtils.getUniquePrefix((XMLStreamWriter)writer);
        }
        if (declare) {
            writer.setPrefix(prefix, namespaceURI);
            writer.writeNamespace(prefix, namespaceURI);
        }
        return prefix;
    }

    public static String makeNamespaceFromClassName(String className, String protocol) {
        int index = className.lastIndexOf(".");
        if (index == -1) {
            return protocol + "://" + "DefaultNamespace";
        }
        String packageName = className.substring(0, index);
        StringTokenizer st = new StringTokenizer(packageName, ".");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuilder sb = new StringBuilder(80);
        for (int i = words.length - 1; i >= 0; --i) {
            String word = words[i];
            if (i != words.length - 1) {
                sb.append('.');
            }
            sb.append(word);
        }
        return protocol + "://" + sb.toString();
    }

    public static String makePackageName(String namespace) {
        String hostname = null;
        String path = "";
        try {
            URL u = new URL(namespace);
            hostname = u.getHost();
            path = u.getPath();
        }
        catch (MalformedURLException e) {
            if (namespace.indexOf(":") > -1) {
                hostname = namespace.substring(namespace.indexOf(":") + 1);
                if (hostname.indexOf("/") > -1) {
                    hostname = hostname.substring(0, hostname.indexOf("/"));
                }
            }
            hostname = namespace;
        }
        if (hostname == null) {
            return null;
        }
        hostname = hostname.replace('-', '_');
        if ((path = path.replace('-', '_')).length() > 0 && path.charAt(path.length() - 1) == '/') {
            path = path.substring(0, path.length() - 1);
        }
        StringTokenizer st = new StringTokenizer(hostname, ".:");
        String[] words = new String[st.countTokens()];
        for (int i = 0; i < words.length; ++i) {
            words[i] = st.nextToken();
        }
        StringBuilder sb = new StringBuilder(namespace.length());
        for (int i = words.length - 1; i >= 0; --i) {
            NamespaceHelper.addWordToPackageBuffer(sb, words[i], i == words.length - 1);
        }
        StringTokenizer st2 = new StringTokenizer(path, "/");
        while (st2.hasMoreTokens()) {
            NamespaceHelper.addWordToPackageBuffer(sb, st2.nextToken(), false);
        }
        return sb.toString();
    }

    private static void addWordToPackageBuffer(StringBuilder sb, String word, boolean firstWord) {
        if (JavaUtils.isJavaKeyword((String)word)) {
            word = JavaUtils.makeNonJavaKeyword((String)word);
        }
        if (!firstWord) {
            sb.append('.');
        }
        if (Character.isDigit(word.charAt(0))) {
            sb.append('_');
        }
        if (word.indexOf(46) != -1) {
            char[] buf = word.toCharArray();
            for (int i = 0; i < word.length(); ++i) {
                if (buf[i] != '.') continue;
                buf[i] = 95;
            }
            word = new String(buf);
        }
        sb.append(word);
    }

    public static QName readQName(XMLStreamReader reader) throws XMLStreamException {
        String value = reader.getElementText();
        if (value == null) {
            return null;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            return new QName(value);
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        String ns = reader.getNamespaceURI(prefix);
        if (ns == null || localName == null) {
            throw new DatabindingException("Invalid QName in mapping: " + value);
        }
        return new QName(ns, localName, prefix);
    }

    public static QName createQName(NamespaceContext nc, String value) {
        if (value == null) {
            return null;
        }
        int index = value.indexOf(58);
        if (index == -1) {
            return new QName(nc.getNamespaceURI(""), value, "");
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        String ns = nc.getNamespaceURI(prefix);
        return new QName(ns, localName, prefix);
    }

    public static QName createQName(Element e, String value, String defaultNamespace) {
        if (value == null) {
            return null;
        }
        int index = value.indexOf(":");
        if (index == -1) {
            return new QName(defaultNamespace, value);
        }
        String prefix = value.substring(0, index);
        String localName = value.substring(index + 1);
        String jNS = DOMUtils.getNamespace((Node)e, (String)prefix);
        if (jNS == null) {
            throw new DatabindingException("No namespace was found for prefix: " + prefix);
        }
        if (jNS == null || localName == null) {
            throw new DatabindingException("Invalid QName in mapping: " + value);
        }
        return new QName(jNS, localName, prefix);
    }
}

