/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapTransportFactory;
import org.apache.cxf.bus.spring.BusApplicationContext;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ResourceResolver;
import org.apache.cxf.transport.http.HttpDestinationFactory;
import org.apache.cxf.transport.servlet.ServletDestinationFactory;
import org.apache.ws.security.WSSConfig;
import org.jboss.logging.Logger;
import org.jboss.ws.api.binding.BindingCustomization;
import org.jboss.ws.api.util.BundleUtils;
import org.jboss.wsf.spi.deployment.Deployment;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.stack.cxf.client.configuration.BeanCustomizer;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSSpringBusFactory;
import org.jboss.wsf.stack.cxf.client.configuration.JBossWSSpringConfigurer;
import org.jboss.wsf.stack.cxf.configuration.BusHolder;
import org.jboss.wsf.stack.cxf.configuration.SecurityActions;
import org.jboss.wsf.stack.cxf.configuration.ServerBeanCustomizer;
import org.jboss.wsf.stack.cxf.deployment.WSDLFilePublisher;
import org.jboss.wsf.stack.cxf.spring.handler.NamespaceHandlerResolver;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class SpringBusHolder
extends BusHolder {
    private static final ResourceBundle bundle = BundleUtils.getBundle(SpringBusHolder.class);
    private static final Logger log = Logger.getLogger(BusHolder.class);
    private boolean configured = false;
    protected BusApplicationContext ctx;
    protected List<GenericApplicationContext> additionalCtx = new LinkedList<GenericApplicationContext>();
    protected URL[] additionalLocations;

    public SpringBusHolder(URL location, URL ... additionalLocations) {
        this.additionalLocations = additionalLocations;
        this.createBus(location);
    }

    protected void createBus(URL location) {
        block3: {
            this.bus = new JBossWSSpringBusFactory().createBus((URL[])null);
            this.ctx = (BusApplicationContext)this.bus.getExtension(BusApplicationContext.class);
            if (location != null) {
                try {
                    this.additionalCtx.add(SpringBusHolder.loadAdditionalConfig((ApplicationContext)this.ctx, location));
                }
                catch (IOException e) {
                    if (!log.isTraceEnabled()) break block3;
                    log.trace((Object)("Could not load additional config from location: " + location), (Throwable)e);
                }
            }
        }
        this.bus.setExtension((Object)new ServletDestinationFactory(), HttpDestinationFactory.class);
    }

    @Override
    public void configure(SoapTransportFactory soapTransportFactory, ResourceResolver resolver, Configurer configurer, Deployment dep) {
        block7: {
            if (this.configured) {
                throw new IllegalStateException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"BUS_IS_ALREADY_CONFIGURED", (Object[])new Object[0]));
            }
            super.configure(soapTransportFactory, resolver, configurer, dep);
            if (this.additionalLocations != null) {
                for (URL jbossCxfXml : this.additionalLocations) {
                    try {
                        this.additionalCtx.add(SpringBusHolder.loadAdditionalConfig((ApplicationContext)this.ctx, jbossCxfXml));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"UNABLE_TO_LOAD_CONFIGURATION", (Object[])new Object[]{jbossCxfXml}), e);
                    }
                }
            }
            try {
                WSSConfig.getNewInstance();
            }
            catch (Exception e) {
                log.warn((Object)BundleUtils.getMessage((ResourceBundle)bundle, (String)"COULD_NOT_INITIALIZE_SECURITY_ENGINE", (Object[])new Object[0]));
                if (!log.isTraceEnabled()) break block7;
                log.trace((Object)"Error while getting default WSSConfig: ", (Throwable)e);
            }
        }
        this.configured = true;
    }

    @Override
    public Configurer createServerConfigurer(BindingCustomization customization, WSDLFilePublisher wsdlPublisher, List<Endpoint> depEndpoints, UnifiedVirtualFile root) {
        ApplicationContext ctx = (ApplicationContext)this.bus.getExtension(BusApplicationContext.class);
        ServerBeanCustomizer customizer = new ServerBeanCustomizer();
        customizer.setBindingCustomization(customization);
        customizer.setWsdlPublisher(wsdlPublisher);
        customizer.setDeploymentEndpoints(depEndpoints);
        customizer.setDeploymentRoot(root);
        Configurer orig = (Configurer)this.bus.getExtension(Configurer.class);
        JBossWSSpringConfigurer serverConfigurer = orig instanceof JBossWSSpringConfigurer ? (JBossWSSpringConfigurer)orig : new JBossWSSpringConfigurer(orig);
        serverConfigurer.setApplicationContext(ctx);
        serverConfigurer.setCustomizer((BeanCustomizer)customizer);
        return serverConfigurer;
    }

    protected static GenericApplicationContext loadAdditionalConfig(ApplicationContext ctx, URL locationUrl) throws IOException {
        if (locationUrl == null) {
            throw new IllegalArgumentException(BundleUtils.getMessage((ResourceBundle)bundle, (String)"CANNOT_LOAD_ADDITIONAL_CONFIG", (Object[])new Object[0]));
        }
        InputStream is = locationUrl.openStream();
        GenericApplicationContext childCtx = new GenericApplicationContext(ctx);
        XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)childCtx);
        reader.setValidationMode(3);
        reader.setNamespaceHandlerResolver((org.springframework.beans.factory.xml.NamespaceHandlerResolver)new NamespaceHandlerResolver(SecurityActions.getContextClassLoader()));
        reader.loadBeanDefinitions((Resource)new InputStreamResource(is));
        childCtx.refresh();
        return childCtx;
    }

    @Override
    public void close() {
        for (GenericApplicationContext gac : this.additionalCtx) {
            gac.destroy();
        }
        super.close();
    }

    @Override
    protected void setBus(Bus bus) {
        super.setBus(bus);
        this.ctx = (BusApplicationContext)bus.getExtension(BusApplicationContext.class);
    }
}

