/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.ssh.term;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.crsh.ssh.term.CRaSHCommand;
import org.crsh.term.CodeType;
import org.crsh.term.spi.TermIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSHIO
implements TermIO {
    private static final int UP = 1001;
    private static final int DOWN = 1002;
    private static final int HANDLED = 1305;
    private static final Logger log = LoggerFactory.getLogger(SSHIO.class);
    private static final String DEL_SEQ = "\b \b";
    private final Reader reader;
    private final Writer writer;
    private static final int STATUS_NORMAL = 0;
    private static final int STATUS_READ_ESC_1 = 1;
    private static final int STATUS_READ_ESC_2 = 2;
    private int status;
    private final CRaSHCommand command;
    final AtomicBoolean closed;

    public SSHIO(CRaSHCommand command) {
        this.command = command;
        this.writer = new OutputStreamWriter(command.out);
        this.reader = new InputStreamReader(command.in);
        this.status = 0;
        this.closed = new AtomicBoolean(false);
    }

    public int read() throws IOException {
        while (!this.closed.get()) {
            int r;
            try {
                r = this.reader.read();
            }
            catch (IOException e) {
                this.close();
                return 1305;
            }
            block1 : switch (this.status) {
                case 0: {
                    if (r == 27) {
                        this.status = 1;
                        break;
                    }
                    return r;
                }
                case 1: {
                    if (r == 91) {
                        this.status = 2;
                        break;
                    }
                    this.status = 0;
                    log.error("Unrecognized stream data " + r + " after reading ESC code");
                    break;
                }
                case 2: {
                    this.status = 0;
                    switch (r) {
                        case 65: {
                            return 1001;
                        }
                        case 66: {
                            return 1002;
                        }
                        case 67: {
                            break block1;
                        }
                        case 68: {
                            break block1;
                        }
                    }
                    log.error("Unrecognized stream data " + r + " after reading ESC+91 code");
                }
            }
        }
        return 1305;
    }

    public int getWidth() {
        return this.command.getContext().getWidth();
    }

    public String getProperty(String name) {
        return this.command.getContext().getProperty(name);
    }

    public CodeType decode(int code) {
        if (code == this.command.getContext().verase) {
            return CodeType.BACKSPACE;
        }
        switch (code) {
            case 1305: {
                return CodeType.CLOSE;
            }
            case 3: {
                return CodeType.BREAK;
            }
            case 9: {
                return CodeType.TAB;
            }
            case 1001: {
                return CodeType.UP;
            }
            case 1002: {
                return CodeType.DOWN;
            }
        }
        return CodeType.CHAR;
    }

    public void close() {
        if (this.closed.get()) {
            log.debug("Attempt to closed again");
        } else {
            log.debug("Closing SSHIO");
            this.command.session.close(false);
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void write(String s) throws IOException {
        this.writer.write(s);
    }

    public void write(char c) throws IOException {
        this.writer.write(c);
    }

    public void writeDel() throws IOException {
        this.writer.write(DEL_SEQ);
    }

    public void writeCRLF() throws IOException {
        this.writer.write("\r\n");
    }

    public boolean moveRight(char c) throws IOException {
        return false;
    }

    public boolean moveLeft() throws IOException {
        return false;
    }
}

