/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.hornetq.core.security.CheckType;
import org.hornetq.core.security.Role;
import org.hornetq.spi.core.security.HornetQSecurityManager;
import org.jboss.as.messaging.HornetQDefaultCredentials;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SimplePrincipal;

public class HornetQSecurityManagerAS7
implements HornetQSecurityManager {
    private SecurityDomainContext securityDomainContext;
    private String defaultUser = null;
    private String defaultPassword = null;

    public HornetQSecurityManagerAS7(SecurityDomainContext sdc) {
        this.securityDomainContext = sdc;
        this.defaultUser = HornetQDefaultCredentials.getUsername();
        this.defaultPassword = HornetQDefaultCredentials.getPassword();
    }

    public boolean validateUser(String username, String password) {
        if (this.defaultUser.equals(username) && this.defaultPassword.equals(password)) {
            return true;
        }
        if (this.securityDomainContext == null) {
            throw MessagingMessages.MESSAGES.securityDomainContextNotSet();
        }
        return this.securityDomainContext.getAuthenticationManager().isValid((Principal)new SimplePrincipal(username), (Object)password, new Subject());
    }

    public boolean validateUserAndRole(String username, String password, Set<Role> roles, CheckType checkType) {
        if (this.defaultUser.equals(username) && this.defaultPassword.equals(password)) {
            return true;
        }
        if (this.securityDomainContext == null) {
            throw MessagingMessages.MESSAGES.securityDomainContextNotSet();
        }
        Subject subject = new Subject();
        boolean authenticated = this.securityDomainContext.getAuthenticationManager().isValid((Principal)new SimplePrincipal(username), (Object)password, subject);
        if (authenticated) {
            SecurityContext securityContext = this.pushSecurityContext(subject, (Principal)new SimplePrincipal(username), password);
            HashSet<SimplePrincipal> principals = new HashSet<SimplePrincipal>();
            for (Role role : roles) {
                if (!checkType.hasRole(role)) continue;
                principals.add(new SimplePrincipal(role.getName()));
            }
            authenticated = this.securityDomainContext.getAuthorizationManager().doesUserHaveRole((Principal)new SimplePrincipal(username), principals);
            HornetQSecurityManagerAS7.setSecurityContextOnAssociation(securityContext);
        }
        return authenticated;
    }

    private SecurityContext pushSecurityContext(final Subject subject, final Principal principal, final Object credential) {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                SecurityContext securityContext;
                SecurityContext currentSecurityContext = SecurityContextAssociation.getSecurityContext();
                if (currentSecurityContext == null) {
                    securityContext = HornetQSecurityManagerAS7.createSecurityContext(subject, principal, credential, HornetQSecurityManagerAS7.this.securityDomainContext.getAuthenticationManager().getSecurityDomain());
                } else {
                    securityContext = currentSecurityContext;
                    securityContext.getUtil().createSubjectInfo(principal, credential, subject);
                }
                HornetQSecurityManagerAS7.setSecurityContextOnAssociation(securityContext);
                return currentSecurityContext;
            }
        });
    }

    private static void setSecurityContextOnAssociation(final SecurityContext sc) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                SecurityContextAssociation.setSecurityContext((SecurityContext)sc);
                return null;
            }
        });
    }

    private static SecurityContext createSecurityContext(final Subject subject, final Principal principal, final Object credential, final String domain) {
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                try {
                    return SecurityContextFactory.createSecurityContext((Principal)principal, (Object)credential, (Subject)subject, (String)domain);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public void addUser(String s, String s1) {
    }

    public void removeUser(String s) {
    }

    public void addRole(String s, String s1) {
    }

    public void removeRole(String s, String s1) {
    }

    public void setDefaultUser(String s) {
    }

    public void start() throws Exception {
    }

    public void stop() throws Exception {
    }

    public boolean isStarted() {
        return false;
    }
}

