/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.messaging.Attribute;
import org.jboss.as.messaging.CommonAttributes;
import org.jboss.as.messaging.ConnectorRefsAttribute;
import org.jboss.as.messaging.Element;
import org.jboss.as.messaging.MessagingLogger;
import org.jboss.as.messaging.MessagingMessages;
import org.jboss.as.messaging.Namespace;
import org.jboss.as.messaging.SecurityRoleAdd;
import org.jboss.as.messaging.jms.JndiEntriesAttribute;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class MessagingSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    private static final MessagingSubsystemParser INSTANCE = new MessagingSubsystemParser();
    private static final char[] NEW_LINE = new char[]{'\n'};
    private static final EnumSet<Element> SIMPLE_ROOT_RESOURCE_ELEMENTS = EnumSet.noneOf(Element.class);

    public static MessagingSubsystemParser getInstance() {
        return INSTANCE;
    }

    protected MessagingSubsystemParser() {
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "messaging");
        address.protect();
        ModelNode subsystemAdd = new ModelNode();
        subsystemAdd.get("operation").set("add");
        subsystemAdd.get("address").set(address);
        list.add(subsystemAdd);
        Namespace schemaVer = Namespace.forUri(reader.getNamespaceURI());
        switch (schemaVer) {
            case MESSAGING_1_0: {
                this.processHornetQServer(reader, address, list, schemaVer);
                break;
            }
            case MESSAGING_1_1: 
            case MESSAGING_1_2: {
                this.processHornetQServers(reader, address, list);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private void processHornetQServers(XMLExtendedStreamReader reader, ModelNode subsystemAddress, List<ModelNode> list) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            Namespace schemaVer = Namespace.forUri(reader.getNamespaceURI());
            switch (schemaVer) {
                case MESSAGING_1_0: 
                case UNKNOWN: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case HORNETQ_SERVER: {
                    this.processHornetQServer(reader, subsystemAddress, list, schemaVer);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void processHornetQServer(XMLExtendedStreamReader reader, ModelNode subsystemAddress, List<ModelNode> list, Namespace namespace) throws XMLStreamException {
        String hqServerName = null;
        String elementName = null;
        switch (namespace) {
            case MESSAGING_1_0: {
                ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
                elementName = "subsystem";
                break;
            }
            default: {
                int count = reader.getAttributeCount();
                if (count > 0) {
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    hqServerName = reader.getAttributeValue(0).trim();
                }
                elementName = "hornetq-server";
            }
        }
        if (hqServerName == null || hqServerName.length() == 0) {
            hqServerName = "default";
        }
        ModelNode address = subsystemAddress.clone();
        address.add("hornetq-server", hqServerName);
        address.protect();
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        list.add(operation);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        int tag = reader.getEventType();
        String localName = null;
        block30: do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            switch (element) {
                case ACCEPTORS: {
                    MessagingSubsystemParser.processAcceptors(reader, address, list);
                    break;
                }
                case ADDRESS_SETTINGS: {
                    MessagingSubsystemParser.processAddressSettings(reader, address, list);
                    break;
                }
                case BINDINGS_DIRECTORY: {
                    MessagingSubsystemParser.parseDirectory(reader, "bindings-directory", address, list);
                    break;
                }
                case BRIDGES: {
                    this.processBridges(reader, address, list);
                    break;
                }
                case BROADCAST_GROUPS: {
                    MessagingSubsystemParser.processBroadcastGroups(reader, address, list);
                    break;
                }
                case CLUSTER_CONNECTIONS: {
                    this.processClusterConnections(reader, address, list);
                    break;
                }
                case CONNECTORS: {
                    MessagingSubsystemParser.processConnectors(reader, address, list);
                    break;
                }
                case CONNECTOR_SERVICES: {
                    MessagingSubsystemParser.processConnectorServices(reader, address, list);
                    break;
                }
                case DISCOVERY_GROUPS: {
                    MessagingSubsystemParser.processDiscoveryGroups(reader, address, list);
                    break;
                }
                case DIVERTS: {
                    MessagingSubsystemParser.parseDiverts(reader, address, list);
                    break;
                }
                case FILE_DEPLOYMENT_ENABLED: {
                    MessagingSubsystemParser.unhandledElement(reader, element);
                    break;
                }
                case GROUPING_HANDLER: {
                    this.processGroupingHandler(reader, address, list);
                    break;
                }
                case JOURNAL_DIRECTORY: {
                    MessagingSubsystemParser.parseDirectory(reader, "journal-directory", address, list);
                    break;
                }
                case LARGE_MESSAGES_DIRECTORY: {
                    MessagingSubsystemParser.parseDirectory(reader, "large-messages-directory", address, list);
                    break;
                }
                case LIVE_CONNECTOR_REF: {
                    String string = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"connector-name");
                    CommonAttributes.LIVE_CONNECTOR_REF.parseAndSetParameter(string, operation, (XMLStreamReader)reader);
                    break;
                }
                case PAGING_DIRECTORY: {
                    MessagingSubsystemParser.parseDirectory(reader, "paging-directory", address, list);
                    break;
                }
                case REMOTING_INTERCEPTORS: {
                    this.processRemotingInterceptors(reader, operation);
                    break;
                }
                case SECURITY_DOMAIN: {
                    MessagingSubsystemParser.handleElementText(reader, element, null, operation);
                    break;
                }
                case SECURITY_SETTINGS: {
                    MessagingSubsystemParser.processSecuritySettings(reader, address, list);
                    break;
                }
                case CORE_QUEUES: {
                    MessagingSubsystemParser.parseQueues(reader, address, list);
                    break;
                }
                case CONNECTION_FACTORIES: {
                    this.processConnectionFactories(reader, address, list);
                    break;
                }
                case JMS_DESTINATIONS: {
                    MessagingSubsystemParser.processJmsDestinations(reader, address, list);
                    break;
                }
                case SCHEDULED_THREAD_POOL_MAX_SIZE: 
                case THREAD_POOL_MAX_SIZE: {
                    MessagingSubsystemParser.handleElementText(reader, element, "server", operation);
                    break;
                }
                case HORNETQ_SERVER: {
                    if (namespace != Namespace.MESSAGING_1_0) continue block30;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                case SUBSYSTEM: {
                    if (namespace == Namespace.MESSAGING_1_0) continue block30;
                    throw ParseUtils.unexpectedEndElement((XMLExtendedStreamReader)reader);
                }
                default: {
                    if (SIMPLE_ROOT_RESOURCE_ELEMENTS.contains((Object)element)) {
                        AttributeDefinition attributeDefinition = element.getDefinition();
                        if (attributeDefinition instanceof SimpleAttributeDefinition) {
                            MessagingSubsystemParser.handleElementText(reader, element, operation);
                            break;
                        }
                        throw MessagingMessages.MESSAGES.unsupportedElement(element.getLocalName());
                    }
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
        } while (reader.hasNext() && !localName.equals(elementName));
    }

    private static void processConnectorServices(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTOR_SERVICE: {
                    MessagingSubsystemParser.processConnectorService(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void processConnectorService(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode serviceAddress = address.clone().add("connector-service", name);
        ModelNode add = Util.getEmptyOperation((String)"add", (ModelNode)serviceAddress);
        updates.add(add);
        EnumSet<Element> required = EnumSet.of(Element.FACTORY_CLASS);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element) && element != Element.PARAM) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            required.remove((Object)element);
            switch (element) {
                case FACTORY_CLASS: {
                    MessagingSubsystemParser.handleElementText(reader, element, add);
                    continue block4;
                }
                case PARAM: {
                    String[] attrs = ParseUtils.requireAttributes((XMLExtendedStreamReader)reader, (String[])new String[]{Attribute.KEY.getLocalName(), Attribute.VALUE.getLocalName()});
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    ModelNode paramAdd = Util.getEmptyOperation((String)"add", (ModelNode)serviceAddress.clone().add("param", attrs[0]));
                    CommonAttributes.VALUE.parseAndSetParameter(attrs[1], paramAdd, (XMLStreamReader)reader);
                    updates.add(paramAdd);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
    }

    private void processClusterConnections(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTER_CONNECTION: {
                    this.processClusterConnection(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void processClusterConnection(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode clusterConnectionAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("cluster-connection", name));
        EnumSet<Element> required = EnumSet.of(Element.ADDRESS, Element.CONNECTOR_REF);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            required.remove((Object)element);
            switch (element) {
                case FORWARD_WHEN_NO_CONSUMERS: 
                case MAX_HOPS: 
                case CONFIRMATION_WINDOW_SIZE: {
                    MessagingSubsystemParser.handleElementText(reader, element, clusterConnectionAdd);
                    continue block8;
                }
                case ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, CommonAttributes.CLUSTER_CONNECTION_ADDRESS.getName(), clusterConnectionAdd);
                    continue block8;
                }
                case CONNECTOR_REF: {
                    MessagingSubsystemParser.handleElementText(reader, element, "simple", clusterConnectionAdd);
                    continue block8;
                }
                case USE_DUPLICATE_DETECTION: 
                case RETRY_INTERVAL: {
                    MessagingSubsystemParser.handleElementText(reader, element, "cluster", clusterConnectionAdd);
                    continue block8;
                }
                case STATIC_CONNECTORS: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.STATIC_CONNECTORS, Element.DISCOVERY_GROUP_REF);
                    this.processStaticConnectors(reader, clusterConnectionAdd, true);
                    continue block8;
                }
                case DISCOVERY_GROUP_REF: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.DISCOVERY_GROUP_REF, Element.STATIC_CONNECTORS);
                    String groupRef = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.DISCOVERY_GROUP_NAME.getXmlName());
                    CommonAttributes.DISCOVERY_GROUP_NAME.parseAndSetParameter(groupRef, clusterConnectionAdd, (XMLStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(clusterConnectionAdd);
    }

    private void processBridges(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BRIDGE: {
                    this.processBridge(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    protected void processBridge(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode bridgeAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("bridge", name));
        EnumSet<Element> required = EnumSet.of(Element.QUEUE_NAME);
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            required.remove((Object)element);
            switch (element) {
                case CONFIRMATION_WINDOW_SIZE: 
                case QUEUE_NAME: 
                case HA: 
                case TRANSFORMER_CLASS_NAME: 
                case RETRY_INTERVAL_MULTIPLIER: 
                case FAILOVER_ON_SERVER_SHUTDOWN: 
                case USER: 
                case PASSWORD: {
                    MessagingSubsystemParser.handleElementText(reader, element, bridgeAdd);
                    continue block8;
                }
                case FILTER: {
                    String string = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.FILTER.parseAndSetParameter(string, bridgeAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                case RETRY_INTERVAL: {
                    MessagingSubsystemParser.handleElementText(reader, element, "default", bridgeAdd);
                    continue block8;
                }
                case USE_DUPLICATE_DETECTION: 
                case FORWARDING_ADDRESS: 
                case RECONNECT_ATTEMPTS: {
                    MessagingSubsystemParser.handleElementText(reader, element, "bridge", bridgeAdd);
                    continue block8;
                }
                case STATIC_CONNECTORS: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.STATIC_CONNECTORS, Element.DISCOVERY_GROUP_REF);
                    this.processStaticConnectors(reader, bridgeAdd, false);
                    continue block8;
                }
                case DISCOVERY_GROUP_REF: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.DISCOVERY_GROUP_REF, Element.STATIC_CONNECTORS);
                    String groupRef = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.DISCOVERY_GROUP_NAME.getXmlName());
                    CommonAttributes.DISCOVERY_GROUP_NAME.parseAndSetParameter(groupRef, bridgeAdd, (XMLStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        this.checkOnlyOneOfElements(reader, seen, Element.STATIC_CONNECTORS, Element.DISCOVERY_GROUP_REF);
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(bridgeAdd);
    }

    protected void processStaticConnectors(XMLExtendedStreamReader reader, ModelNode addOperation, boolean cluster) throws XMLStreamException {
        if (cluster) {
            int count = reader.getAttributeCount();
            block6: for (int i = 0; i < count; ++i) {
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case ALLOW_DIRECT_CONNECTIONS_ONLY: {
                        String attrValue = reader.getAttributeValue(i);
                        CommonAttributes.ALLOW_DIRECT_CONNECTIONS_ONLY.parseAndSetParameter(attrValue, addOperation, (XMLStreamReader)reader);
                        continue block6;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
        } else {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        }
        EnumSet<Element> required = EnumSet.of(Element.CONNECTOR_REF);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case CONNECTOR_REF: {
                    MessagingSubsystemParser.handleElementText(reader, element, cluster ? "cluster-connection" : "bridge", addOperation);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
    }

    private void processGroupingHandler(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode groupingHandlerAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("grouping-handler", name));
        EnumSet<Element> required = EnumSet.of(Element.ADDRESS, Element.TYPE);
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case TYPE: 
                case TIMEOUT: {
                    MessagingSubsystemParser.handleElementText(reader, element, groupingHandlerAdd);
                    continue block4;
                }
                case ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, CommonAttributes.GROUPING_HANDLER_ADDRESS.getName(), groupingHandlerAdd);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(groupingHandlerAdd);
    }

    private void processRemotingInterceptors(XMLExtendedStreamReader reader, ModelNode operation) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLASS_NAME: {
                    String value = reader.getElementText();
                    CommonAttributes.REMOTING_INTERCEPTORS.parseAndAddParameterElement(value, operation, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void processBroadcastGroups(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BROADCAST_GROUP: {
                    MessagingSubsystemParser.parseBroadcastGroup(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseBroadcastGroup(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block7: for (int i = 0; i < count; ++i) {
            String attrValue = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = attrValue;
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode broadcastGroupAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("broadcast-group", name));
        EnumSet<Element> required = EnumSet.of(Element.GROUP_ADDRESS, Element.GROUP_PORT);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case LOCAL_BIND_ADDRESS: 
                case LOCAL_BIND_PORT: 
                case GROUP_ADDRESS: 
                case GROUP_PORT: 
                case SOCKET_BINDING: 
                case BROADCAST_PERIOD: {
                    MessagingSubsystemParser.handleElementText(reader, element, broadcastGroupAdd);
                    continue block8;
                }
                case CONNECTOR_REF: {
                    MessagingSubsystemParser.handleElementText(reader, element, "broadcast-group", broadcastGroupAdd);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(broadcastGroupAdd);
    }

    static void processDiscoveryGroups(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DISCOVERY_GROUP: {
                    MessagingSubsystemParser.parseDiscoveryGroup(reader, address, updates);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseDiscoveryGroup(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = null;
        int count = reader.getAttributeCount();
        block6: for (int i = 0; i < count; ++i) {
            String attrValue = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = attrValue;
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode discoveryGroup = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("discovery-group", name));
        EnumSet<Element> required = EnumSet.of(Element.GROUP_ADDRESS, Element.GROUP_PORT);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case LOCAL_BIND_ADDRESS: 
                case GROUP_ADDRESS: 
                case GROUP_PORT: 
                case SOCKET_BINDING: 
                case REFRESH_TIMEOUT: 
                case INITIAL_WAIT_TIMEOUT: {
                    MessagingSubsystemParser.handleElementText(reader, element, discoveryGroup);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        updates.add(discoveryGroup);
    }

    void processConnectionFactories(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTION_FACTORY: {
                    this.processConnectionFactory(reader, address, updates);
                    continue block4;
                }
                case POOLED_CONNECTION_FACTORY: {
                    this.processPooledConnectionFactory(reader, address, updates);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void processJmsDestinations(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case JMS_QUEUE: {
                    MessagingSubsystemParser.processJMSQueue(reader, address, updates);
                    continue block4;
                }
                case JMS_TOPIC: {
                    MessagingSubsystemParser.processJMSTopic(reader, address, updates);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void processAcceptors(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            int serverId = 0;
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block11;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block11;
                    }
                    case SERVER_ID: {
                        serverId = Integer.valueOf(attrValue);
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            ModelNode acceptorAddress = address.clone();
            ModelNode operation = new ModelNode();
            operation.get("operation").set("add");
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ACCEPTOR: {
                    acceptorAddress.add("acceptor", name);
                    if (socketBinding != null) {
                        operation.get(CommonAttributes.SOCKET_BINDING.getName()).set(socketBinding);
                    }
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, operation, true);
                    break;
                }
                case NETTY_ACCEPTOR: {
                    acceptorAddress.add("remote-acceptor", name);
                    if (socketBinding == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
                    }
                    operation.get(CommonAttributes.SOCKET_BINDING.getName()).set(socketBinding);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, operation, false);
                    break;
                }
                case IN_VM_ACCEPTOR: {
                    acceptorAddress.add("in-vm-acceptor", name);
                    operation.get(CommonAttributes.SERVER_ID.getName()).set(serverId);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, operation, false);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            operation.get("address").set(acceptorAddress);
            updates.add(operation);
        }
    }

    static void parseQueues(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        block6: while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            int count = reader.getAttributeCount();
            block7: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block7;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case QUEUE: {
                    if (name == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME.getLocalName()));
                    }
                    ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("queue", name));
                    MessagingSubsystemParser.parseQueue(reader, op);
                    if (!op.hasDefined(CommonAttributes.QUEUE_ADDRESS.getName())) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Element.ADDRESS.getLocalName()));
                    }
                    list.add(op);
                    continue block6;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static void parseQueue(XMLExtendedStreamReader reader, ModelNode queue) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, CommonAttributes.QUEUE_ADDRESS.getName(), queue);
                    continue block5;
                }
                case FILTER: {
                    String string = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.FILTER.parseAndSetParameter(string, queue, (XMLStreamReader)reader);
                    continue block5;
                }
                case DURABLE: {
                    MessagingSubsystemParser.handleElementText(reader, element, queue);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static ModelNode processSecuritySettings(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operations) throws XMLStreamException {
        ModelNode security = new ModelNode();
        int tag = reader.getEventType();
        String localName = null;
        do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case SECURITY_SETTING: {
                    String match = reader.getAttributeValue(0);
                    ModelNode addr = address.clone();
                    addr.add("security-setting", match);
                    ModelNode operation = new ModelNode();
                    operation.get("operation").set("add");
                    operation.get("address").set(addr);
                    operations.add(operation);
                    MessagingSubsystemParser.parseSecurityRoles(reader, addr, operations);
                }
            }
        } while (reader.hasNext() && localName.equals(Element.SECURITY_SETTING.getLocalName()));
        return security;
    }

    static void parseSecurityRoles(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operations) throws XMLStreamException {
        HashMap<String, HashSet<AttributeDefinition>> permsByRole = new HashMap<String, HashSet<AttributeDefinition>>();
        int tag = reader.getEventType();
        String localName = null;
        do {
            tag = reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element != Element.PERMISSION_ELEMENT_NAME) break;
            EnumSet<Attribute> required = EnumSet.of(Attribute.ROLES_ATTR_NAME, Attribute.TYPE_ATTR_NAME);
            List roles = null;
            AttributeDefinition perm = null;
            int count = reader.getAttributeCount();
            block5: for (int i = 0; i < count; ++i) {
                ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                required.remove((Object)attribute);
                switch (attribute) {
                    case ROLES_ATTR_NAME: {
                        roles = reader.getListAttributeValue(i);
                        continue block5;
                    }
                    case TYPE_ATTR_NAME: {
                        perm = SecurityRoleAdd.ROLE_ATTRIBUTES_BY_XML_NAME.get(reader.getAttributeValue(i));
                        if (perm != null) continue block5;
                        throw ControllerMessages.MESSAGES.invalidAttributeValue(reader.getAttributeValue(i), reader.getAttributeName(i), SecurityRoleAdd.ROLE_ATTRIBUTES_BY_XML_NAME.keySet(), reader.getLocation());
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (!required.isEmpty()) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
            }
            for (String role : roles) {
                HashSet<AttributeDefinition> perms = (HashSet<AttributeDefinition>)permsByRole.get(role = role.trim());
                if (perms == null) {
                    perms = new HashSet<AttributeDefinition>();
                    permsByRole.put(role, perms);
                }
                perms.add(perm);
            }
            reader.discardRemainder();
        } while (reader.hasNext());
        for (Map.Entry entry : permsByRole.entrySet()) {
            String role = (String)entry.getKey();
            Set perms = (Set)entry.getValue();
            ModelNode addr = address.clone();
            addr.add("role", role);
            ModelNode operation = new ModelNode();
            operation.get("operation").set("add");
            operation.get("address").set(addr);
            for (AttributeDefinition perm : SecurityRoleAdd.ROLE_ATTRIBUTES) {
                operation.get(perm.getName()).set(perms.contains(perm));
            }
            operations.add(operation);
        }
    }

    static void processConnectors(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            String socketBinding = null;
            int serverId = 0;
            int count = reader.getAttributeCount();
            block11: for (int i = 0; i < count; ++i) {
                String attrValue = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case NAME: {
                        name = attrValue;
                        continue block11;
                    }
                    case SOCKET_BINDING: {
                        socketBinding = attrValue;
                        continue block11;
                    }
                    case SERVER_ID: {
                        serverId = Integer.valueOf(attrValue);
                        continue block11;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
            }
            ModelNode connectorAddress = address.clone();
            ModelNode operation = new ModelNode();
            operation.get("operation").set("add");
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CONNECTOR: {
                    connectorAddress.add("connector", name);
                    if (socketBinding != null) {
                        operation.get(CommonAttributes.SOCKET_BINDING.getName()).set(socketBinding);
                    }
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, operation, true);
                    break;
                }
                case NETTY_CONNECTOR: {
                    connectorAddress.add("remote-connector", name);
                    if (socketBinding == null) {
                        ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.SOCKET_BINDING));
                    }
                    operation.get(CommonAttributes.SOCKET_BINDING.getName()).set(socketBinding);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, operation, false);
                    break;
                }
                case IN_VM_CONNECTOR: {
                    connectorAddress.add("in-vm-connector", name);
                    operation.get(CommonAttributes.SERVER_ID.getName()).set(serverId);
                    MessagingSubsystemParser.parseTransportConfigurationParams(reader, operation, false);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                }
            }
            operation.get("address").set(connectorAddress);
            updates.add(operation);
        }
    }

    static void processAddressSettings(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> operations) throws XMLStreamException {
        ModelNode settings = new ModelNode();
        String localName = null;
        int tag = reader.getEventType();
        do {
            reader.nextTag();
            localName = reader.getLocalName();
            Element element = Element.forName(localName);
            switch (element) {
                case ADDRESS_SETTING: {
                    String match = reader.getAttributeValue(0);
                    ModelNode operation = MessagingSubsystemParser.parseAddressSettings(reader);
                    operation.get("operation").set("add");
                    operation.get("address").set(address);
                    operation.get("address").add("address-setting", match);
                    operations.add(operation);
                }
            }
        } while (reader.hasNext() && localName.equals(Element.ADDRESS_SETTING.getLocalName()));
    }

    static ModelNode parseAddressSettings(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode addressSettingsSpec = new ModelNode();
        do {
            reader.nextTag();
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            switch (element) {
                case DEAD_LETTER_ADDRESS: 
                case EXPIRY_ADDRESS: 
                case REDELIVERY_DELAY: 
                case MAX_SIZE_BYTES: 
                case PAGE_MAX_CACHE_SIZE: 
                case PAGE_SIZE_BYTES: 
                case MESSAGE_COUNTER_HISTORY_DAY_LIMIT: 
                case ADDRESS_FULL_MESSAGE_POLICY: 
                case LVQ: 
                case MAX_DELIVERY_ATTEMPTS: 
                case REDISTRIBUTION_DELAY: 
                case SEND_TO_DLA_ON_NO_ROUTE: {
                    MessagingSubsystemParser.handleElementText(reader, element, addressSettingsSpec);
                    break;
                }
            }
        } while (!reader.getLocalName().equals(Element.ADDRESS_SETTING.getLocalName()) && reader.getEventType() == 2);
        return addressSettingsSpec;
    }

    static void parseTransportConfigurationParams(XMLExtendedStreamReader reader, ModelNode transportConfig, boolean generic) throws XMLStreamException {
        ModelNode params = new ModelNode();
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            int count = reader.getAttributeCount();
            String key = null;
            String value = null;
            block9: for (int n = 0; n < count; ++n) {
                String attrName = reader.getAttributeLocalName(n);
                Attribute attribute = Attribute.forName(attrName);
                switch (attribute) {
                    case KEY: {
                        key = reader.getAttributeValue(n);
                        continue block9;
                    }
                    case VALUE: {
                        value = reader.getAttributeValue(n);
                        continue block9;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)n);
                    }
                }
            }
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case FACTORY_CLASS: {
                    if (!generic) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    transportConfig.get(CommonAttributes.FACTORY_CLASS.getName()).set(reader.getElementText().trim());
                    continue block8;
                }
                case PARAM: {
                    params.add(key, value);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        transportConfig.get("param").set(params);
    }

    static void parseDirectory(XMLExtendedStreamReader reader, String name, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String path = null;
        String relativeTo = null;
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            String value = reader.getAttributeValue(i);
            switch (attribute) {
                case RELATIVE_TO: {
                    relativeTo = value;
                    continue block4;
                }
                case PATH: {
                    path = value;
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (path == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.PATH));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        ModelNode operation = new ModelNode();
        operation.get("operation").set("add");
        operation.get("address").set(address);
        operation.get("address").add("path", name);
        operation.get("path").set(path);
        if (relativeTo != null) {
            operation.get("relative-to").set(relativeTo);
        }
        updates.add(operation);
    }

    private static void parseDiverts(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DIVERT: {
                    MessagingSubsystemParser.parseDivert(reader, address, list);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private static void parseDivert(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> list) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode divertAdd = Util.getEmptyOperation((String)"add", (ModelNode)address.clone().add("divert", name));
        EnumSet<Element> required = EnumSet.of(Element.ADDRESS, Element.FORWARDING_ADDRESS);
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            required.remove((Object)element);
            switch (element) {
                case ROUTING_NAME: {
                    MessagingSubsystemParser.handleElementText(reader, element, divertAdd);
                    continue block8;
                }
                case ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, CommonAttributes.DIVERT_ADDRESS.getName(), divertAdd);
                    continue block8;
                }
                case FORWARDING_ADDRESS: {
                    MessagingSubsystemParser.handleElementText(reader, element, "divert", divertAdd);
                    continue block8;
                }
                case FILTER: {
                    String string = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.FILTER.parseAndSetParameter(string, divertAdd, (XMLStreamReader)reader);
                    continue block8;
                }
                case TRANSFORMER_CLASS_NAME: {
                    MessagingSubsystemParser.handleElementText(reader, element, divertAdd);
                    continue block8;
                }
                case EXCLUSIVE: {
                    MessagingSubsystemParser.handleElementText(reader, element, divertAdd);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, required);
        }
        list.add(divertAdd);
    }

    static void unhandledElement(XMLExtendedStreamReader reader, Element element) throws XMLStreamException {
        throw MessagingMessages.MESSAGES.ignoringUnhandledElement(element, reader.getLocation().toString());
    }

    static void handleElementText(XMLExtendedStreamReader reader, Element element, ModelNode node) throws XMLStreamException {
        MessagingSubsystemParser.handleElementText(reader, element, null, node);
    }

    static void handleElementText(XMLExtendedStreamReader reader, Element element, String modelName, ModelNode node) throws XMLStreamException {
        AttributeDefinition attributeDefinition;
        AttributeDefinition attributeDefinition2 = attributeDefinition = modelName == null ? element.getDefinition() : element.getDefinition(modelName);
        if (attributeDefinition != null) {
            String value = reader.getElementText();
            if (attributeDefinition instanceof SimpleAttributeDefinition) {
                ((SimpleAttributeDefinition)attributeDefinition).parseAndSetParameter(value, node, (XMLStreamReader)reader);
            } else if (attributeDefinition instanceof ListAttributeDefinition) {
                ((ListAttributeDefinition)attributeDefinition).parseAndAddParameterElement(value, node, (XMLStreamReader)reader);
            }
        } else {
            MessagingSubsystemParser.handleElementText(reader, element, node, ModelType.STRING, true, false);
        }
    }

    static void skipElementText(XMLExtendedStreamReader reader) throws XMLStreamException {
        reader.getElementText();
    }

    @Deprecated
    static void handleElementText(XMLExtendedStreamReader reader, Element element, ModelNode node, ModelType expectedType, boolean allowNull, boolean allowExpression) throws XMLStreamException {
        String value = reader.getElementText();
        if (value != null && value.length() > 0) {
            ModelNode modelValue;
            ModelNode toSet = node.get(element.getLocalName());
            ModelNode modelNode = modelValue = allowExpression ? ParseUtils.parsePossibleExpression((String)value.trim()) : new ModelNode().set(value.trim());
            if (!allowExpression || modelValue.getType() != ModelType.EXPRESSION) {
                toSet.set(modelValue);
            } else {
                try {
                    switch (expectedType) {
                        case BOOLEAN: {
                            toSet.set(modelValue.asBoolean());
                            break;
                        }
                        case BIG_DECIMAL: {
                            toSet.set(modelValue.asBigDecimal());
                            break;
                        }
                        case BIG_INTEGER: {
                            toSet.set(modelValue.asBigInteger());
                            break;
                        }
                        case BYTES: {
                            toSet.set(modelValue.asBytes());
                            break;
                        }
                        case DOUBLE: {
                            toSet.set(modelValue.asDouble());
                            break;
                        }
                        case INT: {
                            toSet.set(modelValue.asInt());
                            break;
                        }
                        case LONG: {
                            toSet.set(modelValue.asLong());
                            break;
                        }
                        case STRING: {
                            toSet.set(modelValue.asString());
                            break;
                        }
                        default: {
                            throw new XMLStreamException(MessagingMessages.MESSAGES.illegalValue(value, element.getLocalName()), reader.getLocation());
                        }
                    }
                }
                catch (IllegalArgumentException iae) {
                    throw new XMLStreamException(MessagingMessages.MESSAGES.illegalValue(value, element.getLocalName(), expectedType), reader.getLocation());
                }
            }
        } else if (!allowNull) {
            throw new XMLStreamException(MessagingMessages.MESSAGES.illegalValue(value, element.getLocalName()), reader.getLocation());
        }
    }

    public Namespace getExpectedNamespace() {
        return Namespace.MESSAGING_1_1;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(this.getExpectedNamespace().getUriString(), false);
        ModelNode node = context.getModelNode();
        ModelNode servers = node.require("hornetq-server");
        boolean first = true;
        for (Property prop : servers.asPropertyList()) {
            this.writeHornetQServer(writer, prop.getName(), prop.getValue());
            if (!first) {
                MessagingSubsystemParser.writeNewLine(writer);
                continue;
            }
            first = false;
        }
        writer.writeEndElement();
    }

    private void writeHornetQServer(XMLExtendedStreamWriter writer, String serverName, ModelNode node) throws XMLStreamException {
        writer.writeStartElement(Element.HORNETQ_SERVER.getLocalName());
        if (!"default".equals(serverName)) {
            writer.writeAttribute(Attribute.NAME.getLocalName(), serverName);
        }
        for (AttributeDefinition simpleAttribute : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            simpleAttribute.marshallAsElement(node, (XMLStreamWriter)writer);
        }
        ModelNode paths = node.get("path");
        if (paths.hasDefined("paging-directory")) {
            MessagingSubsystemParser.writeDirectory(writer, Element.PAGING_DIRECTORY, node.get("path"));
        }
        if (paths.hasDefined("bindings-directory")) {
            MessagingSubsystemParser.writeDirectory(writer, Element.BINDINGS_DIRECTORY, node.get("path"));
        }
        if (paths.hasDefined("journal-directory")) {
            MessagingSubsystemParser.writeDirectory(writer, Element.JOURNAL_DIRECTORY, node.get("path"));
        }
        if (paths.hasDefined("large-messages-directory")) {
            MessagingSubsystemParser.writeDirectory(writer, Element.LARGE_MESSAGES_DIRECTORY, node.get("path"));
        }
        MessagingSubsystemParser.writeNewLine(writer);
        MessagingSubsystemParser.writeConnectors(writer, node);
        MessagingSubsystemParser.writeAcceptors(writer, node);
        if (node.hasDefined("broadcast-group")) {
            this.writeBroadcastGroups(writer, node.get("broadcast-group"));
        }
        if (node.hasDefined("discovery-group")) {
            this.writeDiscoveryGroups(writer, node.get("discovery-group"));
        }
        if (node.hasDefined("divert")) {
            this.writeDiverts(writer, node.get("divert"));
        }
        if (node.hasDefined("queue")) {
            this.writeQueues(writer, node.get("queue"));
        }
        if (node.hasDefined("bridge")) {
            this.writeBridges(writer, node.get("bridge"));
        }
        if (node.hasDefined("cluster-connection")) {
            this.writeClusterConnections(writer, node.get("cluster-connection"));
        }
        if (node.hasDefined("grouping-handler")) {
            this.writeGroupingHandler(writer, node.get("grouping-handler"));
        }
        if (node.hasDefined("security-setting")) {
            this.writeSecuritySettings(writer, node.get("security-setting"));
        }
        if (node.hasDefined("address-setting")) {
            this.writeAddressSettings(writer, node.get("address-setting"));
        }
        if (node.hasDefined("connector-service")) {
            this.writeConnectorServices(writer, node.get("connector-service"));
        }
        if (node.hasDefined("connection-factory") || node.hasDefined("pooled-connection-factory")) {
            boolean hasPcf;
            ModelNode cf = node.get("connection-factory");
            ModelNode pcf = node.get("pooled-connection-factory");
            boolean hasCf = cf.isDefined() && cf.keys().size() > 0;
            boolean bl = hasPcf = cf.isDefined() && cf.keys().size() > 0;
            if (hasCf || hasPcf) {
                writer.writeStartElement("jms-connection-factories");
                if (hasCf) {
                    this.writeConnectionFactories(writer, cf);
                }
                if (hasPcf) {
                    this.writePooledConnectionFactories(writer, pcf);
                }
                writer.writeEndElement();
                MessagingSubsystemParser.writeNewLine(writer);
            }
        }
        if (node.has("jms-queue") || node.has("jms-topic")) {
            boolean hasTopic;
            ModelNode queue = node.get("jms-queue");
            ModelNode topic = node.get("jms-topic");
            boolean hasQueue = queue.isDefined() && queue.keys().size() > 0;
            boolean bl = hasTopic = topic.isDefined() && topic.keys().size() > 0;
            if (hasQueue || hasTopic) {
                writer.writeStartElement("jms-destinations");
                if (hasQueue) {
                    this.writeJmsQueues(writer, node.get("jms-queue"));
                }
                if (hasTopic) {
                    this.writeTopics(writer, node.get("jms-topic"));
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    private void writeConnectorServices(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.CONNECTOR_SERVICES.getLocalName());
            for (Property property : node.asPropertyList()) {
                writer.writeStartElement(Element.CONNECTOR_SERVICE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                ModelNode service = property.getValue();
                for (AttributeDefinition attribute : CommonAttributes.CONNECTOR_SERVICE_ATTRIBUTES) {
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                if (service.hasDefined("param")) {
                    for (Property param : service.get("param").asPropertyList()) {
                        writer.writeEmptyElement(Element.PARAM.getLocalName());
                        writer.writeAttribute(Attribute.KEY.getLocalName(), param.getName());
                        writer.writeAttribute(Attribute.VALUE.getLocalName(), param.getValue().get(CommonAttributes.VALUE.getName()).asString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingSubsystemParser.writeNewLine(writer);
        }
    }

    private void writeBridges(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.BRIDGES.getLocalName());
            for (Property property : node.asPropertyList()) {
                writer.writeStartElement(Element.BRIDGE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                ModelNode bridge = property.getValue();
                for (AttributeDefinition attribute : CommonAttributes.BRIDGE_ATTRIBUTES) {
                    if (CommonAttributes.FILTER == attribute) {
                        this.writeFilter(writer, property.getValue());
                        continue;
                    }
                    if (attribute == CommonAttributes.DISCOVERY_GROUP_NAME) {
                        if (!CommonAttributes.DISCOVERY_GROUP_NAME.isMarshallable(bridge)) continue;
                        writer.writeStartElement(Element.DISCOVERY_GROUP_REF.getLocalName());
                        CommonAttributes.DISCOVERY_GROUP_NAME.marshallAsAttribute(bridge, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                        continue;
                    }
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingSubsystemParser.writeNewLine(writer);
        }
    }

    private void writeClusterConnections(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.CLUSTER_CONNECTIONS.getLocalName());
            for (Property property : node.asPropertyList()) {
                writer.writeStartElement(Element.CLUSTER_CONNECTION.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                ModelNode cluster = property.getValue();
                for (AttributeDefinition attribute : CommonAttributes.CLUSTER_CONNECTION_ATTRIBUTES) {
                    if (attribute == CommonAttributes.ALLOW_DIRECT_CONNECTIONS_ONLY) continue;
                    if (attribute == ConnectorRefsAttribute.CLUSTER_CONNECTION_CONNECTORS) {
                        if (ConnectorRefsAttribute.CLUSTER_CONNECTION_CONNECTORS.isMarshallable(cluster)) {
                            writer.writeStartElement(Element.STATIC_CONNECTORS.getLocalName());
                            CommonAttributes.ALLOW_DIRECT_CONNECTIONS_ONLY.marshallAsAttribute(cluster, (XMLStreamWriter)writer);
                            ConnectorRefsAttribute.CLUSTER_CONNECTION_CONNECTORS.marshallAsElement(cluster, (XMLStreamWriter)writer);
                            writer.writeEndElement();
                            continue;
                        }
                        if (!CommonAttributes.ALLOW_DIRECT_CONNECTIONS_ONLY.isMarshallable(cluster)) continue;
                        writer.writeEmptyElement(Element.STATIC_CONNECTORS.getLocalName());
                        CommonAttributes.ALLOW_DIRECT_CONNECTIONS_ONLY.marshallAsAttribute(cluster, (XMLStreamWriter)writer);
                        continue;
                    }
                    if (attribute == CommonAttributes.DISCOVERY_GROUP_NAME) {
                        if (!CommonAttributes.DISCOVERY_GROUP_NAME.isMarshallable(cluster)) continue;
                        writer.writeStartElement(Element.DISCOVERY_GROUP_REF.getLocalName());
                        CommonAttributes.DISCOVERY_GROUP_NAME.marshallAsAttribute(cluster, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                        continue;
                    }
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingSubsystemParser.writeNewLine(writer);
        }
    }

    private void writeGroupingHandler(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        boolean wroteHandler = false;
        for (Property handler : node.asPropertyList()) {
            if (wroteHandler) {
                throw MessagingMessages.MESSAGES.multipleChildrenFound("grouping-handler");
            }
            wroteHandler = true;
            writer.writeStartElement(Element.GROUPING_HANDLER.getLocalName());
            writer.writeAttribute(Attribute.NAME.getLocalName(), handler.getName());
            ModelNode resourceModel = handler.getValue();
            for (AttributeDefinition attr : CommonAttributes.GROUPING_HANDLER_ATTRIBUTES) {
                attr.marshallAsElement(resourceModel, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
            MessagingSubsystemParser.writeNewLine(writer);
        }
    }

    static void writeAcceptors(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined("acceptor") || node.hasDefined("remote-acceptor") || node.hasDefined("in-vm-acceptor")) {
            writer.writeStartElement(Element.ACCEPTORS.getLocalName());
            if (node.hasDefined("acceptor")) {
                for (Property property : node.get("acceptor").asPropertyList()) {
                    writer.writeStartElement(Element.ACCEPTOR.getLocalName());
                    MessagingSubsystemParser.writeAcceptorAndConnectorContent(writer, property);
                    writer.writeEndElement();
                }
            }
            if (node.hasDefined("remote-acceptor")) {
                for (Property property : node.get("remote-acceptor").asPropertyList()) {
                    writer.writeStartElement(Element.NETTY_ACCEPTOR.getLocalName());
                    MessagingSubsystemParser.writeAcceptorAndConnectorContent(writer, property);
                    writer.writeEndElement();
                }
            }
            if (node.hasDefined("in-vm-acceptor")) {
                for (Property property : node.get("in-vm-acceptor").asPropertyList()) {
                    writer.writeStartElement(Element.IN_VM_ACCEPTOR.getLocalName());
                    MessagingSubsystemParser.writeAcceptorAndConnectorContent(writer, property);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            MessagingSubsystemParser.writeNewLine(writer);
        }
    }

    static void writeConnectors(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined("connector") || node.hasDefined("remote-connector") || node.hasDefined("in-vm-connector")) {
            writer.writeStartElement(Element.CONNECTORS.getLocalName());
            if (node.hasDefined("connector")) {
                for (Property property : node.get("connector").asPropertyList()) {
                    writer.writeStartElement(Element.CONNECTOR.getLocalName());
                    MessagingSubsystemParser.writeAcceptorAndConnectorContent(writer, property);
                    writer.writeEndElement();
                }
            }
            if (node.hasDefined("remote-connector")) {
                for (Property property : node.get("remote-connector").asPropertyList()) {
                    writer.writeStartElement(Element.NETTY_CONNECTOR.getLocalName());
                    MessagingSubsystemParser.writeAcceptorAndConnectorContent(writer, property);
                    writer.writeEndElement();
                }
            }
            if (node.hasDefined("in-vm-connector")) {
                for (Property property : node.get("in-vm-connector").asPropertyList()) {
                    writer.writeStartElement(Element.IN_VM_CONNECTOR.getLocalName());
                    MessagingSubsystemParser.writeAcceptorAndConnectorContent(writer, property);
                    writer.writeEndElement();
                }
            }
            writer.writeEndElement();
            MessagingSubsystemParser.writeNewLine(writer);
        }
    }

    static void writeAcceptorAndConnectorContent(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
        ModelNode value = property.getValue();
        if (value.hasDefined(CommonAttributes.SOCKET_BINDING.getName())) {
            MessagingSubsystemParser.writeAttribute(writer, Attribute.SOCKET_BINDING, value.get(CommonAttributes.SOCKET_BINDING.getName()));
        }
        if (value.hasDefined(CommonAttributes.SERVER_ID.getName())) {
            MessagingSubsystemParser.writeAttribute(writer, Attribute.SERVER_ID, value.get(CommonAttributes.SERVER_ID.getName()));
        }
        CommonAttributes.FACTORY_CLASS.marshallAsElement(value, (XMLStreamWriter)writer);
        if (value.hasDefined("param")) {
            for (Property parameter : value.get("param").asPropertyList()) {
                writer.writeStartElement(Element.PARAM.getLocalName());
                writer.writeAttribute(Attribute.KEY.getLocalName(), parameter.getName());
                MessagingSubsystemParser.writeAttribute(writer, Attribute.VALUE, parameter.getValue().get("value"));
                writer.writeEndElement();
            }
        }
    }

    private void writeSecuritySettings(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.SECURITY_SETTINGS.getLocalName());
            for (Property matchRoles : properties) {
                writer.writeStartElement(Element.SECURITY_SETTING.getLocalName());
                writer.writeAttribute(Attribute.MATCH.getLocalName(), matchRoles.getName());
                if (matchRoles.getValue().hasDefined("role")) {
                    ArrayList<String> send = new ArrayList<String>();
                    ArrayList<String> consume = new ArrayList<String>();
                    ArrayList<String> createDurableQueue = new ArrayList<String>();
                    ArrayList<String> deleteDurableQueue = new ArrayList<String>();
                    ArrayList<String> createNonDurableQueue = new ArrayList<String>();
                    ArrayList<String> deleteNonDurableQueue = new ArrayList<String>();
                    ArrayList<String> manageRoles = new ArrayList<String>();
                    for (Property rolePerms : matchRoles.getValue().get("role").asPropertyList()) {
                        String role = rolePerms.getName();
                        ModelNode perms = rolePerms.getValue();
                        if (perms.get(SecurityRoleAdd.SEND.getName()).asBoolean(false)) {
                            send.add(role);
                        }
                        if (perms.get(SecurityRoleAdd.CONSUME.getName()).asBoolean(false)) {
                            consume.add(role);
                        }
                        if (perms.get(SecurityRoleAdd.CREATE_DURABLE_QUEUE.getName()).asBoolean(false)) {
                            createDurableQueue.add(role);
                        }
                        if (perms.get(SecurityRoleAdd.DELETE_DURABLE_QUEUE.getName()).asBoolean(false)) {
                            deleteDurableQueue.add(role);
                        }
                        if (perms.get(SecurityRoleAdd.CREATE_NON_DURABLE_QUEUE.getName()).asBoolean(false)) {
                            createNonDurableQueue.add(role);
                        }
                        if (perms.get(SecurityRoleAdd.DELETE_NON_DURABLE_QUEUE.getName()).asBoolean(false)) {
                            deleteNonDurableQueue.add(role);
                        }
                        if (!perms.get(SecurityRoleAdd.MANAGE.getName()).asBoolean(false)) continue;
                        manageRoles.add(role);
                    }
                    this.writePermission(writer, SecurityRoleAdd.SEND.getXmlName(), send);
                    this.writePermission(writer, SecurityRoleAdd.CONSUME.getXmlName(), consume);
                    this.writePermission(writer, SecurityRoleAdd.CREATE_DURABLE_QUEUE.getXmlName(), createDurableQueue);
                    this.writePermission(writer, SecurityRoleAdd.DELETE_DURABLE_QUEUE.getXmlName(), deleteDurableQueue);
                    this.writePermission(writer, SecurityRoleAdd.CREATE_NON_DURABLE_QUEUE.getXmlName(), createNonDurableQueue);
                    this.writePermission(writer, SecurityRoleAdd.DELETE_NON_DURABLE_QUEUE.getXmlName(), deleteNonDurableQueue);
                    this.writePermission(writer, SecurityRoleAdd.MANAGE.getXmlName(), manageRoles);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingSubsystemParser.writeNewLine(writer);
        }
    }

    private void writePermission(XMLExtendedStreamWriter writer, String type, List<String> roles) throws XMLStreamException {
        if (roles.size() == 0) {
            return;
        }
        writer.writeStartElement(Element.PERMISSION_ELEMENT_NAME.getLocalName());
        StringBuilder sb = new StringBuilder();
        for (String role : roles) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(role);
        }
        writer.writeAttribute(Attribute.TYPE_ATTR_NAME.getLocalName(), type);
        writer.writeAttribute(Attribute.ROLES_ATTR_NAME.getLocalName(), sb.toString());
        writer.writeEndElement();
    }

    private void writeAddressSettings(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.ADDRESS_SETTINGS.getLocalName());
            for (Property matchSetting : properties) {
                writer.writeStartElement(Element.ADDRESS_SETTING.getLocalName());
                writer.writeAttribute(Attribute.MATCH.getLocalName(), matchSetting.getName());
                ModelNode setting = matchSetting.getValue();
                CommonAttributes.DEAD_LETTER_ADDRESS.marshallAsElement(setting, (XMLStreamWriter)writer);
                CommonAttributes.EXPIRY_ADDRESS.marshallAsElement(setting, (XMLStreamWriter)writer);
                CommonAttributes.REDELIVERY_DELAY.marshallAsElement(setting, (XMLStreamWriter)writer);
                CommonAttributes.MAX_DELIVERY_ATTEMPTS.marshallAsElement(setting, (XMLStreamWriter)writer);
                CommonAttributes.MAX_SIZE_BYTES.marshallAsElement(setting, (XMLStreamWriter)writer);
                CommonAttributes.PAGE_SIZE_BYTES.marshallAsElement(setting, (XMLStreamWriter)writer);
                CommonAttributes.PAGE_MAX_CACHE_SIZE.marshallAsElement(setting, (XMLStreamWriter)writer);
                CommonAttributes.ADDRESS_FULL_MESSAGE_POLICY.marshallAsElement(setting, (XMLStreamWriter)writer);
                CommonAttributes.MESSAGE_COUNTER_HISTORY_DAY_LIMIT.marshallAsElement(setting, (XMLStreamWriter)writer);
                CommonAttributes.LVQ.marshallAsElement(setting, (XMLStreamWriter)writer);
                CommonAttributes.REDISTRIBUTION_DELAY.marshallAsElement(setting, (XMLStreamWriter)writer);
                CommonAttributes.SEND_TO_DLA_ON_NO_ROUTE.marshallAsElement(setting, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingSubsystemParser.writeNewLine(writer);
        }
    }

    private void writeQueues(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.CORE_QUEUES.getLocalName());
            for (Property queueProp : properties) {
                writer.writeStartElement(Element.QUEUE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), queueProp.getName());
                ModelNode queue = queueProp.getValue();
                CommonAttributes.QUEUE_ADDRESS.marshallAsElement(queue, (XMLStreamWriter)writer);
                this.writeFilter(writer, queue);
                CommonAttributes.DURABLE.marshallAsElement(queue, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingSubsystemParser.writeNewLine(writer);
        }
    }

    private void writeBroadcastGroups(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.BROADCAST_GROUPS.getLocalName());
            for (Property property : properties) {
                writer.writeStartElement(Element.BROADCAST_GROUP.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                for (AttributeDefinition attribute : CommonAttributes.BROADCAST_GROUP_ATTRIBUTES) {
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingSubsystemParser.writeNewLine(writer);
        }
    }

    private void writeDiscoveryGroups(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.DISCOVERY_GROUPS.getLocalName());
            for (Property property : properties) {
                writer.writeStartElement(Element.DISCOVERY_GROUP.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                for (AttributeDefinition attribute : CommonAttributes.DISCOVERY_GROUP_ATTRIBUTES) {
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingSubsystemParser.writeNewLine(writer);
        }
    }

    private void writeDiverts(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            writer.writeStartElement(Element.DIVERTS.getLocalName());
            for (Property property : properties) {
                writer.writeStartElement(Element.DIVERT.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
                for (AttributeDefinition attribute : CommonAttributes.DIVERT_ATTRIBUTES) {
                    if (CommonAttributes.FILTER == attribute) {
                        this.writeFilter(writer, property.getValue());
                        continue;
                    }
                    attribute.marshallAsElement(property.getValue(), (XMLStreamWriter)writer);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            MessagingSubsystemParser.writeNewLine(writer);
        }
    }

    private void writeFilter(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined(CommonAttributes.FILTER.getName())) {
            writer.writeEmptyElement(CommonAttributes.FILTER.getXmlName());
            writer.writeAttribute("string", node.get(CommonAttributes.FILTER.getName()).asString());
        }
    }

    static void writeDirectory(XMLExtendedStreamWriter writer, Element element, ModelNode node) throws XMLStreamException {
        String localName = element.getLocalName();
        if (node.has(localName)) {
            String relativeTo;
            String path = node.get(localName).has(CommonAttributes.PATH.getName()) ? node.get(new String[]{localName, CommonAttributes.PATH.getName()}).asString() : null;
            String string = relativeTo = node.get(localName).hasDefined(CommonAttributes.RELATIVE_TO.getName()) ? node.get(new String[]{localName, CommonAttributes.RELATIVE_TO.getName()}).asString() : null;
            if (path != null || relativeTo != null) {
                writer.writeEmptyElement(localName);
                if (path != null) {
                    writer.writeAttribute(CommonAttributes.PATH.getName(), path);
                }
                if (relativeTo != null) {
                    writer.writeAttribute(CommonAttributes.RELATIVE_TO.getName(), relativeTo);
                }
            }
        }
    }

    private void writeConnectionFactories(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            for (Property prop : properties) {
                String name = prop.getName();
                ModelNode factory = prop.getValue();
                if (!factory.isDefined()) continue;
                writer.writeStartElement(Element.CONNECTION_FACTORY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                this.writeRegularConnectionFactoryAttributes(writer, name, factory);
                this.writeCommonConnectionFactoryAttributes(writer, name, factory);
            }
        }
    }

    private void writePooledConnectionFactories(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            for (Property prop : properties) {
                String name = prop.getName();
                ModelNode factory = prop.getValue();
                if (!factory.isDefined()) continue;
                writer.writeStartElement(Element.POOLED_CONNECTION_FACTORY.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                this.writePooledConnectionFactoryAttributes(writer, name, factory);
                this.writeCommonConnectionFactoryAttributes(writer, name, factory);
            }
        }
    }

    protected void writeRegularConnectionFactoryAttributes(XMLExtendedStreamWriter writer, String name, ModelNode factory) throws XMLStreamException {
        CommonAttributes.CONNECTION_FACTORY_TYPE.marshallAsElement(factory, (XMLStreamWriter)writer);
    }

    protected void writePooledConnectionFactoryAttributes(XMLExtendedStreamWriter writer, String name, ModelNode factory) throws XMLStreamException {
        ModelNode inboundConfigs;
        CommonAttributes.PCF_USER.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.PCF_PASSWORD.marshallAsElement(factory, (XMLStreamWriter)writer);
        if (factory.hasDefined("inbound-config") && (inboundConfigs = factory.get("inbound-config")).getType() == ModelType.LIST) {
            writer.writeStartElement(Element.INBOUND_CONFIG.getLocalName());
            for (ModelNode config : inboundConfigs.asList()) {
                if (!config.isDefined()) continue;
                CommonAttributes.USE_JNDI.marshallAsElement(config, (XMLStreamWriter)writer);
                CommonAttributes.JNDI_PARAMS.marshallAsElement(config, (XMLStreamWriter)writer);
                CommonAttributes.USE_LOCAL_TX.marshallAsElement(config, (XMLStreamWriter)writer);
                CommonAttributes.SETUP_ATTEMPTS.marshallAsElement(config, (XMLStreamWriter)writer);
                CommonAttributes.SETUP_INTERVAL.marshallAsElement(config, (XMLStreamWriter)writer);
            }
            writer.writeEndElement();
        }
        if (factory.hasDefined("transaction")) {
            writer.writeStartElement(Element.TRANSACTION.getLocalName());
            this.writeTransactionTypeAttribute(writer, Element.MODE, factory.get("transaction"));
            writer.writeEndElement();
        }
    }

    protected void writeCommonConnectionFactoryAttributes(XMLExtendedStreamWriter writer, String name, ModelNode factory) throws XMLStreamException {
        if (CommonAttributes.DISCOVERY_GROUP_NAME.isMarshallable(factory)) {
            writer.writeStartElement(Element.DISCOVERY_GROUP_REF.getLocalName());
            CommonAttributes.DISCOVERY_GROUP_NAME.marshallAsAttribute(factory, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        CommonAttributes.DISCOVERY_INITIAL_WAIT_TIMEOUT.marshallAsElement(factory, (XMLStreamWriter)writer);
        if (factory.hasDefined("connector")) {
            writer.writeStartElement(Element.CONNECTORS.getLocalName());
            for (Property connProp : factory.get("connector").asPropertyList()) {
                writer.writeStartElement(Element.CONNECTOR_REF.getLocalName());
                writer.writeAttribute(Attribute.CONNECTOR_NAME.getLocalName(), connProp.getName());
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        JndiEntriesAttribute.CONNECTION_FACTORY.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.HA.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.CLIENT_FAILURE_CHECK_PERIOD.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.CONNECTION_TTL.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.CALL_TIMEOUT.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.CONSUMER_WINDOW_SIZE.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.CONSUMER_MAX_RATE.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.CONFIRMATION_WINDOW_SIZE.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.PRODUCER_WINDOW_SIZE.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.PRODUCER_MAX_RATE.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.CACHE_LARGE_MESSAGE_CLIENT.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.MIN_LARGE_MESSAGE_SIZE.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.CLIENT_ID.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.DUPS_OK_BATCH_SIZE.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.TRANSACTION_BATCH_SIZE.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.BLOCK_ON_ACK.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.BLOCK_ON_NON_DURABLE_SEND.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.BLOCK_ON_DURABLE_SEND.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.AUTO_GROUP.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.PRE_ACK.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.RETRY_INTERVAL.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.RETRY_INTERVAL_MULTIPLIER.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.MAX_RETRY_INTERVAL.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.CONNECTION_FACTORY_RECONNECT_ATTEMPTS.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.FAILOVER_ON_INITIAL_CONNECTION.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.FAILOVER_ON_SERVER_SHUTDOWN.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.LOAD_BALANCING_CLASS_NAME.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.USE_GLOBAL_POOLS.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.CONNECTION_SCHEDULED_THREAD_POOL_MAX_SIZE.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.CONNECTION_THREAD_POOL_MAX_SIZE.marshallAsElement(factory, (XMLStreamWriter)writer);
        CommonAttributes.GROUP_ID.marshallAsElement(factory, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    private void writeJmsQueues(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            for (Property prop : properties) {
                String name = prop.getName();
                ModelNode queue = prop.getValue();
                if (!queue.isDefined()) continue;
                writer.writeStartElement(Element.JMS_QUEUE.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                CommonAttributes.ENTRIES.marshallAsElement(queue, (XMLStreamWriter)writer);
                CommonAttributes.DURABLE.marshallAsElement(queue, (XMLStreamWriter)writer);
                CommonAttributes.SELECTOR.marshallAsElement(queue, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
    }

    private void writeTopics(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        List properties = node.asPropertyList();
        if (!properties.isEmpty()) {
            for (Property prop : properties) {
                String name = prop.getName();
                ModelNode topic = prop.getValue();
                if (!topic.isDefined()) continue;
                writer.writeStartElement(Element.JMS_TOPIC.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                CommonAttributes.ENTRIES.marshallAsElement(topic, (XMLStreamWriter)writer);
                writer.writeEndElement();
            }
        }
    }

    private void writeTransactionTypeAttribute(XMLExtendedStreamWriter writer, Element attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }

    static void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }

    static void processJMSTopic(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = reader.getAttributeValue(0);
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode topic = new ModelNode();
        topic.get("operation").set("add");
        topic.get("address").set(address).add("jms-topic", name);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY: {
                    String entry = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    CommonAttributes.ENTRIES.parseAndAddParameterElement(entry, topic, (XMLStreamReader)reader);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        updates.add(topic);
    }

    static void processJMSQueue(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode queue = new ModelNode();
        queue.get("operation").set("add");
        queue.get("address").set(address).add("jms-queue", name);
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ENTRY: {
                    String entry = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                    CommonAttributes.ENTRIES.parseAndAddParameterElement(entry, queue, (XMLStreamReader)reader);
                    continue block5;
                }
                case SELECTOR: {
                    if (queue.has(CommonAttributes.SELECTOR.getName())) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.SELECTOR.getLocalName());
                    }
                    ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"string");
                    String selector = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"string");
                    CommonAttributes.SELECTOR.parseAndSetParameter(selector, queue, (XMLStreamReader)reader);
                    continue block5;
                }
                case DURABLE: {
                    if (queue.has(CommonAttributes.DURABLE.getName())) {
                        throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)Element.DURABLE.getLocalName());
                    }
                    MessagingSubsystemParser.handleElementText(reader, element, queue);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        updates.add(queue);
    }

    void processConnectionFactory(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        ParseUtils.requireSingleAttribute((XMLExtendedStreamReader)reader, (String)"name");
        String name = reader.getAttributeValue(0);
        ModelNode connectionFactory = new ModelNode();
        connectionFactory.get("operation").set("add");
        connectionFactory.get("address").set(address).add("connection-factory", name);
        updates.add(this.createConnectionFactory(reader, connectionFactory, false));
    }

    void processPooledConnectionFactory(XMLExtendedStreamReader reader, ModelNode address, List<ModelNode> updates) throws XMLStreamException {
        String name = reader.getAttributeValue(0);
        if (name == null) {
            ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton("name"));
        }
        ModelNode connectionFactory = new ModelNode();
        connectionFactory.get("operation").set("add");
        connectionFactory.get("address").set(address).add("pooled-connection-factory", name);
        updates.add(this.createConnectionFactory(reader, connectionFactory, true));
    }

    static ModelNode processJmsConnectors(XMLExtendedStreamReader reader) throws XMLStreamException {
        ModelNode connectors = new ModelNode();
        while (reader.hasNext() && reader.nextTag() != 2) {
            String name = null;
            int count = reader.getAttributeCount();
            block5: for (int i = 0; i < count; ++i) {
                String value = reader.getAttributeValue(i);
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case CONNECTOR_NAME: {
                        name = value.trim();
                        continue block5;
                    }
                    case BACKUP_CONNECTOR_NAME: {
                        MessagingLogger.ROOT_LOGGER.deprecatedXMLAttribute(attribute.toString());
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
            }
            if (name == null) {
                throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.CONNECTOR_NAME));
            }
            Element element = Element.forName(reader.getLocalName());
            if (element != Element.CONNECTOR_REF) {
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
            connectors.get(name);
        }
        return connectors;
    }

    protected ModelNode createConnectionFactory(XMLExtendedStreamReader reader, ModelNode connectionFactory, boolean pooled) throws XMLStreamException {
        EnumSet<Element> seen = EnumSet.noneOf(Element.class);
        block17: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            if (!seen.add(element)) {
                throw ParseUtils.duplicateNamedElement((XMLExtendedStreamReader)reader, (String)element.getLocalName());
            }
            switch (element) {
                case DISCOVERY_GROUP_REF: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.DISCOVERY_GROUP_REF, Element.CONNECTORS);
                    String groupRef = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)CommonAttributes.DISCOVERY_GROUP_NAME.getXmlName());
                    CommonAttributes.DISCOVERY_GROUP_NAME.parseAndSetParameter(groupRef, connectionFactory, (XMLStreamReader)reader);
                    continue block17;
                }
                case CONNECTORS: {
                    this.checkOtherElementIsNotAlreadyDefined((XMLStreamReader)reader, seen, Element.CONNECTORS, Element.DISCOVERY_GROUP_REF);
                    connectionFactory.get("connector").set(MessagingSubsystemParser.processJmsConnectors(reader));
                    continue block17;
                }
                case ENTRIES: {
                    Element local;
                    while (reader.hasNext() && reader.nextTag() != 2) {
                        local = Element.forName(reader.getLocalName());
                        if (local != Element.ENTRY) {
                            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                        }
                        String entry = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)"name");
                        JndiEntriesAttribute.CONNECTION_FACTORY.parseAndAddParameterElement(entry, connectionFactory, (XMLStreamReader)reader);
                    }
                    continue block17;
                }
                case CONFIRMATION_WINDOW_SIZE: 
                case HA: 
                case RETRY_INTERVAL_MULTIPLIER: 
                case FAILOVER_ON_SERVER_SHUTDOWN: 
                case CLIENT_FAILURE_CHECK_PERIOD: 
                case CONNECTION_TTL: 
                case CALL_TIMEOUT: 
                case CONSUMER_WINDOW_SIZE: 
                case CONSUMER_MAX_RATE: 
                case PRODUCER_WINDOW_SIZE: 
                case PRODUCER_MAX_RATE: 
                case CACHE_LARGE_MESSAGE_CLIENT: 
                case MIN_LARGE_MESSAGE_SIZE: 
                case CLIENT_ID: 
                case DUPS_OK_BATCH_SIZE: 
                case TRANSACTION_BATH_SIZE: 
                case BLOCK_ON_ACK: 
                case BLOCK_ON_NON_DURABLE_SEND: 
                case BLOCK_ON_DURABLE_SEND: 
                case AUTO_GROUP: 
                case PRE_ACK: 
                case MAX_RETRY_INTERVAL: 
                case FAILOVER_ON_INITIAL_CONNECTION: 
                case LOAD_BALANCING_CLASS_NAME: 
                case USE_GLOBAL_POOLS: 
                case GROUP_ID: {
                    MessagingSubsystemParser.handleElementText(reader, element, connectionFactory);
                    continue block17;
                }
                case RETRY_INTERVAL: {
                    MessagingSubsystemParser.handleElementText(reader, element, "default", connectionFactory);
                    continue block17;
                }
                case SCHEDULED_THREAD_POOL_MAX_SIZE: 
                case THREAD_POOL_MAX_SIZE: 
                case RECONNECT_ATTEMPTS: {
                    MessagingSubsystemParser.handleElementText(reader, element, "connection", connectionFactory);
                    continue block17;
                }
                case DISCOVERY_INITIAL_WAIT_TIMEOUT: {
                    MessagingLogger.ROOT_LOGGER.deprecatedXMLElement(element.toString());
                    MessagingSubsystemParser.skipElementText(reader);
                    continue block17;
                }
                case CONNECTION_FACTORY_TYPE: {
                    if (pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    MessagingSubsystemParser.handleElementText(reader, element, connectionFactory);
                    continue block17;
                }
                case INBOUND_CONFIG: {
                    Element local;
                    if (!pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    block19: while (reader.hasNext() && reader.nextTag() != 2) {
                        local = Element.forName(reader.getLocalName());
                        switch (local) {
                            case USE_JNDI: 
                            case JNDI_PARAMS: 
                            case USE_LOCAL_TX: 
                            case SETUP_ATTEMPTS: 
                            case SETUP_INTERVAL: {
                                MessagingSubsystemParser.handleElementText(reader, local, connectionFactory);
                                continue block19;
                            }
                        }
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    continue block17;
                }
                case TRANSACTION: {
                    if (!pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    String txType = reader.getAttributeValue(0);
                    if (txType != null) {
                        connectionFactory.get("transaction").set(txType);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue block17;
                }
                case USER: {
                    if (!pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    CommonAttributes.PCF_USER.parseAndSetParameter(reader.getElementText(), connectionFactory, (XMLStreamReader)reader);
                    continue block17;
                }
                case PASSWORD: {
                    if (!pooled) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    CommonAttributes.PCF_PASSWORD.parseAndSetParameter(reader.getElementText(), connectionFactory, (XMLStreamReader)reader);
                    continue block17;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        this.checkOnlyOneOfElements(reader, seen, Element.CONNECTORS, Element.DISCOVERY_GROUP_REF);
        return connectionFactory;
    }

    private static void writeNewLine(XMLExtendedStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters(NEW_LINE, 0, 1);
    }

    protected void checkOtherElementIsNotAlreadyDefined(XMLStreamReader reader, Set<Element> seen, Element currentElement, Element otherElement) throws XMLStreamException {
        if (seen.contains((Object)otherElement)) {
            throw new XMLStreamException(MessagingMessages.MESSAGES.illegalElement(currentElement.getLocalName(), otherElement.getLocalName()), reader.getLocation());
        }
    }

    protected void checkOnlyOneOfElements(XMLExtendedStreamReader reader, Set<Element> seen, Element element1, Element element2) throws XMLStreamException {
        if (!seen.contains((Object)element1) && !seen.contains((Object)element2)) {
            throw new XMLStreamException(MessagingMessages.MESSAGES.required(element1.getLocalName(), element2.getLocalName()), reader.getLocation());
        }
        if (seen.contains((Object)element1) && seen.contains((Object)element2)) {
            throw new XMLStreamException(MessagingMessages.MESSAGES.onlyOneRequired(element1.getLocalName(), element2.getLocalName()), reader.getLocation());
        }
    }

    static {
        for (AttributeDefinition attr : CommonAttributes.SIMPLE_ROOT_RESOURCE_ATTRIBUTES) {
            SIMPLE_ROOT_RESOURCE_ELEMENTS.add(Element.forName(attr.getXmlName()));
        }
    }
}

