/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.context;

import java.io.Serializable;
import javax.enterprise.context.spi.Contextual;
import org.jboss.weld.Container;
import org.jboss.weld.context.ForwardingContextual;
import org.jboss.weld.serialization.spi.ContextualStore;
import org.jboss.weld.serialization.spi.helpers.SerializableContextual;

public class SerializableContextualImpl<C extends Contextual<I>, I>
extends ForwardingContextual<I>
implements SerializableContextual<C, I> {
    private static final long serialVersionUID = 9161034819867283482L;
    private C serialiazable;
    private transient C cached;
    private String id;
    private transient ContextualStore cachedContextualStore;

    @Override
    protected Contextual<I> delegate() {
        return this.get();
    }

    private SerializableContextualImpl() {
    }

    public SerializableContextualImpl(C contextual, ContextualStore contextualStore) {
        this.cachedContextualStore = contextualStore;
        if (contextual instanceof Serializable) {
            this.serialiazable = contextual;
        } else {
            this.id = contextualStore.putIfAbsent(contextual);
        }
        this.cached = contextual;
    }

    private ContextualStore getContextualStore() {
        if (this.cachedContextualStore == null) {
            this.cachedContextualStore = (ContextualStore)Container.instance().services().get(ContextualStore.class);
        }
        return this.cachedContextualStore;
    }

    public C get() {
        if (this.cached == null) {
            this.loadContextual();
        }
        return this.cached;
    }

    private void loadContextual() {
        if (this.serialiazable != null) {
            this.cached = this.serialiazable;
        } else if (this.id != null) {
            this.cached = this.getContextualStore().getContextual(this.id);
        }
        if (this.cached == null) {
            throw new IllegalStateException("Error restoring serialized contextual with id " + this.id);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SerializableContextualImpl) {
            return this.delegate().equals(((SerializableContextualImpl)obj).get());
        }
        return this.delegate().equals(obj);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }
}

