/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.resolution;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import org.jboss.weld.bean.RIBean;
import org.jboss.weld.exceptions.WeldException;
import org.jboss.weld.introspector.WeldMethod;
import org.jboss.weld.manager.BeanManagerImpl;
import org.jboss.weld.metadata.cache.MetaAnnotationStore;
import org.jboss.weld.metadata.cache.QualifierModel;

public class QualifierInstance {
    private final Class<? extends Annotation> annotationClass;
    private final Map<WeldMethod<?, ?>, Object> values;
    private final int hashCode;

    public static Set<QualifierInstance> qualifiers(BeanManagerImpl beanManager, Set<Annotation> annotations) {
        if (annotations.isEmpty()) {
            return Collections.emptySet();
        }
        MetaAnnotationStore store = (MetaAnnotationStore)beanManager.getServices().get(MetaAnnotationStore.class);
        HashSet<QualifierInstance> ret = new HashSet<QualifierInstance>();
        for (Annotation a : annotations) {
            ret.add(new QualifierInstance(a, store));
        }
        return ret;
    }

    public static Set<QualifierInstance> qualifiers(BeanManagerImpl beanManager, Bean<?> bean) {
        if (bean instanceof RIBean) {
            return ((RIBean)bean).getQualifierInstances();
        }
        return QualifierInstance.qualifiers(beanManager, bean.getQualifiers());
    }

    public QualifierInstance(Annotation instance, MetaAnnotationStore store) {
        this.annotationClass = instance.annotationType();
        QualifierModel<? extends Annotation> model = store.getBindingTypeModel(this.annotationClass);
        HashMap values = new HashMap();
        for (WeldMethod<?, ?> method : model.getAnnotatedAnnotation().getMembers()) {
            if (model.getNonBindingMembers().contains(method)) continue;
            try {
                values.put(method, method.invoke(instance, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new WeldException(e);
            }
            catch (InvocationTargetException e) {
                throw new WeldException(e);
            }
        }
        this.values = Collections.unmodifiableMap(values);
        int result = this.annotationClass.hashCode();
        this.hashCode = result = 31 * result + ((Object)values).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifierInstance that = (QualifierInstance)o;
        if (!this.annotationClass.equals(that.annotationClass)) {
            return false;
        }
        return ((Object)this.values).equals(that.values);
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "QualifierInstance{annotationClass=" + this.annotationClass + ", values=" + this.values + ", hashCode=" + this.hashCode + '}';
    }
}

