/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.atomic;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;
import org.infinispan.atomic.Operation;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public class PutOperation<K, V>
extends Operation<K, V> {
    private K key;
    private V oldValue;
    private V newValue;

    public PutOperation() {
    }

    PutOperation(K key, V oldValue, V newValue) {
        this.key = key;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public void rollback(Map<K, V> delegate) {
        if (this.oldValue == null) {
            delegate.remove(this.key);
        } else {
            delegate.put(this.key, this.oldValue);
        }
    }

    @Override
    public void replay(Map<K, V> delegate) {
        delegate.put(this.key, this.newValue);
    }

    @Override
    public K keyAffected() {
        return this.key;
    }

    public static class Externalizer
    extends AbstractExternalizer<PutOperation> {
        @Override
        public void writeObject(ObjectOutput output, PutOperation put) throws IOException {
            output.writeObject(put.key);
            output.writeObject(put.newValue);
        }

        @Override
        public PutOperation readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            PutOperation put = new PutOperation();
            put.key = input.readObject();
            put.newValue = input.readObject();
            return put;
        }

        @Override
        public Integer getId() {
            return 47;
        }

        @Override
        public Set<Class<? extends PutOperation>> getTypeClasses() {
            return Util.asSet(PutOperation.class);
        }
    }
}

