/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors;

import java.util.concurrent.TimeUnit;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.config.Configuration;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.statetransfer.StateTransferInProgressException;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.statetransfer.StateTransferLockReacquisitionException;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferLockInterceptor
extends CommandInterceptor {
    StateTransferLock stateTransferLock;
    private long rpcTimeout;
    private static final Log log = LogFactory.getLog(StateTransferLockInterceptor.class);

    @Override
    protected Log getLog() {
        return log;
    }

    @Inject
    public void init(StateTransferLock stateTransferLock, Configuration configuration) {
        this.stateTransferLock = stateTransferLock;
        this.rpcTimeout = configuration.getCacheMode().isSynchronous() ? configuration.getSyncReplTimeout() : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            return this.signalStateTransferInProgress(ctx);
        }
        boolean release = true;
        try {
            Object object = this.handleWithRetries(ctx, command, this.rpcTimeout);
            return object;
        }
        catch (StateTransferLockReacquisitionException e) {
            release = false;
            Object object = this.signalStateTransferInProgress(ctx);
            return object;
        }
        finally {
            if (release) {
                this.stateTransferLock.releaseForCommand(ctx, command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            return this.signalStateTransferInProgress(ctx);
        }
        boolean release = true;
        try {
            Object object = this.handleWithRetries(ctx, command, this.rpcTimeout);
            return object;
        }
        catch (StateTransferLockReacquisitionException e) {
            release = false;
            Object object = this.signalStateTransferInProgress(ctx);
            return object;
        }
        finally {
            if (release) {
                this.stateTransferLock.releaseForCommand(ctx, command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            return this.signalStateTransferInProgress(ctx);
        }
        boolean release = true;
        try {
            Object object = this.handleWithRetries(ctx, command, -1L);
            return object;
        }
        catch (StateTransferLockReacquisitionException e) {
            release = false;
            Object object = this.signalStateTransferInProgress(ctx);
            return object;
        }
        finally {
            if (release) {
                this.stateTransferLock.releaseForCommand(ctx, command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            return this.signalStateTransferInProgress(ctx);
        }
        boolean release = true;
        try {
            Object object = this.handleWithRetries(ctx, command, this.rpcTimeout);
            return object;
        }
        catch (StateTransferLockReacquisitionException e) {
            release = false;
            Object object = this.signalStateTransferInProgress(ctx);
            return object;
        }
        finally {
            if (release) {
                this.stateTransferLock.releaseForCommand(ctx, command);
            }
        }
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleWriteCommand(ctx, command);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handleWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (!this.stateTransferLock.acquireForCommand(ctx, command)) {
            return this.signalStateTransferInProgress(ctx);
        }
        boolean release = true;
        try {
            Object object = this.handleWithRetries(ctx, command, this.rpcTimeout);
            return object;
        }
        catch (StateTransferLockReacquisitionException e) {
            release = false;
            Object object = this.signalStateTransferInProgress(ctx);
            return object;
        }
        finally {
            if (release) {
                this.stateTransferLock.releaseForCommand(ctx, command);
            }
        }
    }

    private Object signalStateTransferInProgress(InvocationContext ctx) {
        int viewId = this.stateTransferLock.getBlockingCacheViewId();
        if (ctx.isOriginLocal()) {
            throw new StateTransferInProgressException(viewId, "Timed out waiting for the state transfer lock, state transfer in progress for view " + viewId);
        }
        throw new StateTransferInProgressException(viewId, "State transfer in progress on target node for view " + viewId + ", returning to the originator to allow state transfer to proceed.");
    }

    private Object handleWithRetries(InvocationContext ctx, VisitableCommand command, long timeoutMillis) throws Throwable {
        long endNanos = timeoutMillis > 0L ? System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeoutMillis) : Long.MAX_VALUE;
        while (true) {
            int newCacheViewId = -1;
            try {
                return this.invokeNextInterceptor(ctx, command);
            }
            catch (StateTransferInProgressException e) {
                newCacheViewId = e.getNewCacheViewId();
                log.debugf("Caught StateTransferInProgressException, waiting for the state transfer %d to start", newCacheViewId);
            }
            catch (SuspectException e) {
                log.debugf("Caught SuspectException, waiting for the state transfer %d to start", ++newCacheViewId);
            }
            if (endNanos < System.nanoTime()) {
                throw new TimeoutException("Timed out waiting for the state transfer to end");
            }
            this.stateTransferLock.waitForStateTransferToEnd(ctx, command, newCacheViewId);
        }
    }
}

