/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.wss.cxf.producer;

import java.util.Map;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JOutInterceptor;
import org.gatein.wsrp.wss.cxf.WSSConfiguration;
import org.gatein.wsrp.wss.cxf.producer.GTNSubjectCreatingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WSRPWSSecurityFeature
extends AbstractFeature {
    private static Logger log = LoggerFactory.getLogger(WSRPWSSecurityFeature.class);
    protected static String GTN_SCI_INTERCEPTOR_CONFIG_FILE = "GTNSubjectCreatingInterceptor.properties";

    public WSRPWSSecurityFeature() {
        log.debug("WSRPWSSecurityFeature Constructed");
    }

    public void initialize(Server server, Bus bus) {
        Map<String, Object> inPropertyMap = WSSConfiguration.getWSS4JInterceptorConfiguration(false, true);
        Map<String, Object> outPropertyMap = WSSConfiguration.getWSS4JInterceptorConfiguration(false, false);
        Map<String, Object> sciPropertyMap = WSSConfiguration.getCXFConfiguration(false, GTN_SCI_INTERCEPTOR_CONFIG_FILE, "GTNSubjectCreatingInterceptor");
        if (sciPropertyMap != null) {
            GTNSubjectCreatingInterceptor sci = new GTNSubjectCreatingInterceptor(sciPropertyMap);
            server.getEndpoint().getInInterceptors().add(sci);
        }
        if (inPropertyMap != null) {
            WSS4JInInterceptor inInterceptor = new WSS4JInInterceptor(inPropertyMap);
            server.getEndpoint().getInInterceptors().add(inInterceptor);
        }
        if (outPropertyMap != null) {
            WSS4JOutInterceptor outInterceptor = new WSS4JOutInterceptor(outPropertyMap);
            server.getEndpoint().getOutInterceptors().add(outInterceptor);
        }
    }
}

