/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.descriptions;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DomainRootDescription {
    private static final String RESOURCE_NAME = DomainRootDescription.class.getPackage().getName() + ".LocalDescriptions";

    public static ResourceDescriptionResolver getResourceDescriptionResolver(String keyPrefix) {
        return new StandardResourceDescriptionResolver(keyPrefix, RESOURCE_NAME, DomainRootDescription.class.getClassLoader(), true, true);
    }

    public static ModelNode getDescription(Locale locale) {
        ResourceBundle bundle2 = DomainRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("description").set(bundle2.getString("domain"));
        root.get("head-comment-allowed").set(true);
        root.get("tail-comment-allowed").set(true);
        root.get(new String[]{"attributes", "namespaces"}).set(CommonDescriptions.getNamespacePrefixAttribute((Locale)locale));
        root.get(new String[]{"attributes", "schema-locations"}).set(CommonDescriptions.getSchemaLocationAttribute((Locale)locale));
        root.get(new String[]{"attributes", "process-type", "description"}).set(bundle2.getString("domain.process-type"));
        root.get(new String[]{"attributes", "process-type", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "process-type", "required"}).set(true);
        root.get(new String[]{"attributes", "process-type", "nillable"}).set(false);
        root.get(new String[]{"attributes", "process-type", "min-length"}).set(1);
        root.get(new String[]{"attributes", "process-type", "allowed"}).add("Domain Controller");
        root.get(new String[]{"attributes", "process-type", "allowed"}).add("Host Controller");
        root.get(new String[]{"attributes", "release-version", "description"}).set(bundle2.getString("domain.release-version"));
        root.get(new String[]{"attributes", "release-version", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "release-version", "required"}).set(true);
        root.get(new String[]{"attributes", "release-version", "nillable"}).set(false);
        root.get(new String[]{"attributes", "release-version", "min-length"}).set(1);
        root.get(new String[]{"attributes", "release-codename", "description"}).set(bundle2.getString("domain.release-codename"));
        root.get(new String[]{"attributes", "release-codename", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "release-codename", "required"}).set(true);
        root.get(new String[]{"attributes", "release-codename", "nillable"}).set(false);
        root.get(new String[]{"attributes", "release-codename", "min-length"}).set(1);
        root.get(new String[]{"attributes", "product-name", "description"}).set(bundle2.getString("domain.product-name"));
        root.get(new String[]{"attributes", "product-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "product-name", "required"}).set(true);
        root.get(new String[]{"attributes", "product-name", "nillable"}).set(true);
        root.get(new String[]{"attributes", "product-name", "min-length"}).set(1);
        root.get(new String[]{"attributes", "product-version", "description"}).set(bundle2.getString("domain.product-version"));
        root.get(new String[]{"attributes", "product-version", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "product-version", "required"}).set(true);
        root.get(new String[]{"attributes", "product-version", "nillable"}).set(true);
        root.get(new String[]{"attributes", "product-version", "min-length"}).set(1);
        root.get(new String[]{"attributes", "management-major-version", "description"}).set(bundle2.getString("domain.management-major-version"));
        root.get(new String[]{"attributes", "management-major-version", "type"}).set(ModelType.INT);
        root.get(new String[]{"attributes", "management-major-version", "required"}).set(true);
        root.get(new String[]{"attributes", "management-major-version", "nillable"}).set(false);
        root.get(new String[]{"attributes", "management-major-version", "min"}).set(1);
        root.get(new String[]{"attributes", "management-minor-version", "description"}).set(bundle2.getString("domain.management-minor-version"));
        root.get(new String[]{"attributes", "management-minor-version", "type"}).set(ModelType.INT);
        root.get(new String[]{"attributes", "management-minor-version", "required"}).set(true);
        root.get(new String[]{"attributes", "management-minor-version", "nillable"}).set(false);
        root.get(new String[]{"attributes", "management-minor-version", "min"}).set(1);
        root.get(new String[]{"attributes", "local-host-name", "description"}).set(bundle2.getString("domain.local-host-name"));
        root.get(new String[]{"attributes", "local-host-name", "type"}).set(ModelType.STRING);
        root.get(new String[]{"attributes", "local-host-name", "required"}).set(true);
        root.get(new String[]{"attributes", "local-host-name", "nillable"}).set(false);
        root.get("operations").setEmptyObject();
        root.get(new String[]{"children", "extension", "description"}).set(bundle2.getString("domain.extension"));
        root.get(new String[]{"children", "extension", "min-occurs"}).set(0);
        root.get(new String[]{"children", "extension", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "extension", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "path", "description"}).set(bundle2.getString("domain.path"));
        root.get(new String[]{"children", "path", "min-occurs"}).set(0);
        root.get(new String[]{"children", "path", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "path", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "system-property", "description"}).set(bundle2.getString("domain.system-properties"));
        root.get(new String[]{"children", "system-property", "min-occurs"}).set(0);
        root.get(new String[]{"children", "system-property", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "system-property", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "profile", "description"}).set(bundle2.getString("domain.profile"));
        root.get(new String[]{"children", "profile", "min-occurs"}).set(1);
        root.get(new String[]{"children", "profile", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "profile", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "interface", "description"}).set(bundle2.getString("domain.interface"));
        root.get(new String[]{"children", "interface", "min-occurs"}).set(0);
        root.get(new String[]{"children", "interface", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "interface", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "socket-binding-group", "description"}).set(bundle2.getString("domain.socket-binding-group"));
        root.get(new String[]{"children", "socket-binding-group", "min-occurs"}).set(0);
        root.get(new String[]{"children", "socket-binding-group", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "socket-binding-group", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "deployment", "description"}).set(bundle2.getString("domain.deployment"));
        root.get(new String[]{"children", "deployment", "min-occurs"}).set(0);
        root.get(new String[]{"children", "deployment", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "deployment", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "server-group", "description"}).set(bundle2.getString("domain.server-group"));
        root.get(new String[]{"children", "server-group", "min-occurs"}).set(0);
        root.get(new String[]{"children", "server-group", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "server-group", "model-description"}).setEmptyObject();
        root.get(new String[]{"children", "host", "description"}).set(bundle2.getString("domain.host"));
        root.get(new String[]{"children", "host", "min-occurs"}).set(0);
        root.get(new String[]{"children", "host", "max-occurs"}).set(Integer.MAX_VALUE);
        root.get(new String[]{"children", "host", "model-description"}).setEmptyObject();
        return root;
    }

    public static ModelNode getDeploymentRemoveOperation(Locale locale) {
        ResourceBundle bundle2 = DomainRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("remove");
        root.get("description").set(bundle2.getString("domain.deployment.remove"));
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getSystemPropertiesDescription(Locale locale) {
        ResourceBundle bundle2 = DomainRootDescription.getResourceBundle(locale);
        return CommonDescriptions.getSystemPropertyDescription((Locale)locale, (String)bundle2.getString("domain.system-property"), (boolean)true);
    }

    public static ModelNode getRestartServersOperation(Locale locale) {
        ResourceBundle bundle2 = DomainRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("restart-servers");
        root.get("description").set(bundle2.getString("domain.servers.restart"));
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getStopServersOperation(Locale locale) {
        ResourceBundle bundle2 = DomainRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("stop-servers");
        root.get("description").set(bundle2.getString("domain.servers.stop"));
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    public static ModelNode getStartServersOperation(Locale locale) {
        ResourceBundle bundle2 = DomainRootDescription.getResourceBundle(locale);
        ModelNode root = new ModelNode();
        root.get("operation-name").set("start-servers");
        root.get("description").set(bundle2.getString("domain.servers.start"));
        root.get("reply-properties").setEmptyObject();
        return root;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

