/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.bridge.scope;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.portlet.PortletContext;
import javax.portlet.PortletSession;
import org.jboss.portletbridge.bridge.config.BridgeConfig;
import org.jboss.portletbridge.bridge.context.BridgeContext;
import org.jboss.portletbridge.bridge.factory.BridgeFactoryFinder;
import org.jboss.portletbridge.bridge.factory.BridgeLoggerFactoryImpl;
import org.jboss.portletbridge.bridge.factory.BridgeRequestScopeFactory;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;
import org.jboss.portletbridge.bridge.scope.BridgeRequestScope;
import org.jboss.portletbridge.bridge.scope.BridgeRequestScopeCache;
import org.jboss.portletbridge.bridge.scope.BridgeRequestScopeManager;
import org.jboss.portletbridge.bridge.scope.BridgeRequestScopeUtil;

public class BridgeRequestScopeManagerImpl
implements BridgeRequestScopeManager,
Serializable {
    private static final int DEFAULT_MAX_MANAGED_REQUEST_SCOPES = 100;
    private static final BridgeLogger logger = BridgeLoggerFactoryImpl.getLogger(BridgeRequestScopeManagerImpl.class.getName());
    private transient BridgeRequestScopeFactory scopeFactory = this.retrieveScopeFactory();
    private Map<String, BridgeRequestScope> bridgeRequestScopeCache;
    private Map<String, String> scopeIdMap;

    public BridgeRequestScopeManagerImpl(BridgeConfig bridgeConfig) {
        this.bridgeRequestScopeCache = this.createBridgeRequestScopeCache(bridgeConfig.getPortletConfig().getPortletContext());
        this.scopeIdMap = new HashMap<String, String>(this.getCacheMax(bridgeConfig.getPortletConfig().getPortletContext()));
    }

    public BridgeRequestScope createRequestScope(BridgeContext ctx, String portletName, String sessionId, String viewId, String portletMode) {
        BridgeRequestScope scope = this.getScopeFactory().getBridgeRequestScope(portletName, sessionId, viewId, portletMode);
        this.bridgeRequestScopeCache.put(scope.getId(), scope);
        this.scopeIdMap.put(BridgeRequestScopeUtil.generateBridgeRequestScopeIdPrefix(portletName, sessionId, viewId, portletMode), scope.getId());
        return scope;
    }

    public BridgeRequestScope createRequestScope(BridgeContext ctx, String viewId) {
        return this.createRequestScope(ctx, ctx.getBridgeConfig().getPortletConfig().getPortletName(), ctx.getPortletRequest().getPortletSession(true).getId(), viewId, ctx.getPortletRequest().getPortletMode().toString());
    }

    public BridgeRequestScope getRequestScopeById(BridgeContext ctx, String id) {
        return this.bridgeRequestScopeCache.get(id);
    }

    public BridgeRequestScope getRequestScope(BridgeContext ctx, String portletName, String sessionId, String viewId, String portletMode) {
        String idPrefix = BridgeRequestScopeUtil.generateBridgeRequestScopeIdPrefix(portletName, sessionId, viewId, portletMode);
        String scopeKey = this.scopeIdMap.get(idPrefix);
        BridgeRequestScope scope = null;
        if (null != scopeKey && null == (scope = this.getRequestScopeById(ctx, scopeKey))) {
            this.scopeIdMap.remove(idPrefix);
        }
        return scope;
    }

    public BridgeRequestScope getRequestScope(BridgeContext ctx, String viewId, String portletMode) {
        return this.getRequestScope(ctx, ctx.getBridgeConfig().getPortletConfig().getPortletName(), ctx.getPortletRequest().getPortletSession(true).getId(), viewId, portletMode);
    }

    public BridgeRequestScope getRequestScope(BridgeContext ctx, String viewId) {
        return this.getRequestScope(ctx, viewId, ctx.getPortletRequest().getPortletMode().toString());
    }

    public BridgeRequestScope getRequestScope(BridgeContext ctx) {
        return this.getRequestScope(ctx, ctx.getFacesViewId(true));
    }

    public BridgeRequestScope removeRequestScopeById(BridgeContext ctx, String id) {
        BridgeRequestScope scope = this.bridgeRequestScopeCache.remove(id);
        scope.clear();
        return scope;
    }

    public BridgeRequestScope removeRequestScope(BridgeContext ctx, BridgeRequestScope scope) {
        return this.removeRequestScope(ctx, scope.getId());
    }

    public BridgeRequestScope removeRequestScope(BridgeContext ctx, String portletName, String sessionId, String viewId, String portletMode) {
        String idPrefix = BridgeRequestScopeUtil.generateBridgeRequestScopeIdPrefix(portletName, sessionId, viewId, portletMode);
        String scopeKey = this.scopeIdMap.get(idPrefix);
        BridgeRequestScope scope = null;
        if (null != scopeKey && null == (scope = this.removeRequestScopeById(ctx, scopeKey))) {
            this.scopeIdMap.remove(idPrefix);
        }
        return scope;
    }

    public BridgeRequestScope removeRequestScope(BridgeContext ctx, String viewId, String portletMode) {
        return this.removeRequestScope(ctx, ctx.getBridgeConfig().getPortletConfig().getPortletName(), ctx.getPortletRequest().getPortletSession(true).getId(), viewId, portletMode);
    }

    public BridgeRequestScope removeRequestScope(BridgeContext ctx, String viewId) {
        return this.removeRequestScope(ctx, viewId, ctx.getPortletRequest().getPortletMode().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestScopesByPortlet(BridgeContext ctx, String portletName) {
        Set<Map.Entry<String, BridgeRequestScope>> entries;
        if (null != portletName && null != (entries = this.bridgeRequestScopeCache.entrySet())) {
            Map<String, BridgeRequestScope> map = this.bridgeRequestScopeCache;
            synchronized (map) {
                for (Map.Entry<String, BridgeRequestScope> entry : entries) {
                    BridgeRequestScope scope = entry.getValue();
                    if (!portletName.equals(scope.getPortletName())) continue;
                    this.removeRequestScopeById(ctx, entry.getKey());
                }
            }
        }
    }

    public void removeRequestScopesByPortlet(BridgeContext ctx) {
        this.removeRequestScopesByPortlet(ctx, ctx.getBridgeConfig().getPortletConfig().getPortletName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRequestScopesBySession(BridgeContext ctx, String sessionId) {
        Set<Map.Entry<String, BridgeRequestScope>> entries;
        if (null != sessionId && null != (entries = this.bridgeRequestScopeCache.entrySet())) {
            Map<String, BridgeRequestScope> map = this.bridgeRequestScopeCache;
            synchronized (map) {
                for (Map.Entry<String, BridgeRequestScope> entry : entries) {
                    BridgeRequestScope scope = entry.getValue();
                    if (!sessionId.equals(scope.getSessionId())) continue;
                    this.removeRequestScopeById(ctx, entry.getKey());
                }
            }
        }
    }

    public void removeRequestScopesBySession(BridgeContext ctx) {
        PortletSession portletSession = ctx.getPortletRequest().getPortletSession(false);
        if (null != portletSession) {
            this.removeRequestScopesBySession(ctx, portletSession.getId());
        }
    }

    protected Map<String, BridgeRequestScope> createBridgeRequestScopeCache(PortletContext portletContext) {
        return Collections.synchronizedMap(new BridgeRequestScopeCache(this.getCacheMax(portletContext)));
    }

    private int getCacheMax(PortletContext portletContext) {
        int maxManagedScopes = 100;
        String maxManagedScopesInitParam = portletContext.getInitParameter("javax.portlet.faces.MAX_MANAGED_REQUEST_SCOPES");
        if (null != maxManagedScopesInitParam) {
            try {
                maxManagedScopes = Integer.parseInt(maxManagedScopesInitParam);
            }
            catch (NumberFormatException e) {
                logger.log(BridgeLogger.Level.WARNING, "portlet.xml contains invalid value for javax.portlet.faces.MAX_MANAGED_REQUEST_SCOPES");
            }
        }
        return maxManagedScopes;
    }

    public BridgeRequestScopeFactory getScopeFactory() {
        if (this.scopeFactory == null) {
            this.scopeFactory = this.retrieveScopeFactory();
        }
        return this.scopeFactory;
    }

    private BridgeRequestScopeFactory retrieveScopeFactory() {
        return (BridgeRequestScopeFactory)BridgeFactoryFinder.getFactoryInstance(BridgeRequestScopeFactory.class);
    }
}

