/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.deployment.spi;

import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.jboss.as.ee.deployment.spi.DeploymentLogger;
import org.jboss.as.ee.deployment.spi.DeploymentManagerImpl;
import org.jboss.as.ee.deployment.spi.DeploymentMessages;
import org.jboss.as.ee.deployment.spi.JBossTarget;
import org.jboss.as.ee.deployment.spi.status.ProgressObjectImpl;

final class DeploymentWorker
extends Thread {
    private final ProgressObjectImpl progress;
    private final DeploymentManagerImpl.DeploymentManagerState managerState;

    DeploymentWorker(ProgressObject progress, DeploymentManagerImpl.DeploymentManagerState managerState) {
        this.progress = (ProgressObjectImpl)progress;
        this.managerState = managerState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        DeploymentLogger.ROOT_LOGGER.tracef("Begin run", new Object[0]);
        try {
            CommandType cmdType = this.progress.getDeploymentStatus().getCommand();
            TargetModuleID[] modules = this.progress.getResultTargetModuleIDs();
            for (int i = 0; i < modules.length; ++i) {
                TargetModuleID moduleid = modules[i];
                JBossTarget target = (JBossTarget)moduleid.getTarget();
                try {
                    this.progress.sendProgressEvent(StateType.RUNNING, DeploymentMessages.MESSAGES.operationStarted(cmdType), moduleid);
                    if (cmdType == CommandType.DISTRIBUTE) {
                        target.deploy(moduleid);
                    } else if (cmdType == CommandType.START) {
                        target.start(moduleid);
                    } else if (cmdType == CommandType.STOP) {
                        target.stop(moduleid);
                    } else if (cmdType == CommandType.UNDEPLOY) {
                        target.undeploy(moduleid);
                    }
                    this.progress.sendProgressEvent(StateType.COMPLETED, DeploymentMessages.MESSAGES.operationCompleted(cmdType), moduleid);
                    continue;
                }
                catch (Exception e) {
                    String message = DeploymentMessages.MESSAGES.operationFailedOnTarget(cmdType, target);
                    this.progress.sendProgressEvent(StateType.FAILED, message, moduleid);
                    DeploymentLogger.ROOT_LOGGER.errorf(e, message, new Object[0]);
                }
            }
        }
        finally {
            if (this.managerState != null) {
                this.managerState.cleanup();
            }
        }
        DeploymentLogger.ROOT_LOGGER.tracef("End run", new Object[0]);
    }
}

