/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jgroups.logging.Log;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.Util;

public class DiagnosticsHandler
implements Runnable {
    public static final String THREAD_NAME = "DiagnosticsHandler";
    protected Thread thread = null;
    protected MulticastSocket diag_sock = null;
    protected InetAddress diagnostics_addr = null;
    protected int diagnostics_port = 7500;
    protected final Set<ProbeHandler> handlers = new CopyOnWriteArraySet<ProbeHandler>();
    protected final Log log;
    protected final SocketFactory socket_factory;
    protected final ThreadFactory thread_factory;

    public DiagnosticsHandler(InetAddress diagnostics_addr, int diagnostics_port, Log log, SocketFactory socket_factory, ThreadFactory thread_factory) {
        this.diagnostics_addr = diagnostics_addr;
        this.diagnostics_port = diagnostics_port;
        this.log = log;
        this.socket_factory = socket_factory;
        this.thread_factory = thread_factory;
    }

    public Thread getThread() {
        return this.thread;
    }

    public Set<ProbeHandler> getProbeHandlers() {
        return this.handlers;
    }

    public void registerProbeHandler(ProbeHandler handler) {
        if (handler != null) {
            this.handlers.add(handler);
        }
    }

    public void unregisterProbeHandler(ProbeHandler handler) {
        if (handler != null) {
            this.handlers.remove(handler);
        }
    }

    public void start() throws IOException {
        this.diag_sock = this.socket_factory.createMulticastSocket("jgroups.tp.diag.mcast_sock", this.diagnostics_port);
        List<NetworkInterface> interfaces = Util.getAllAvailableInterfaces();
        this.bindToInterfaces(interfaces, this.diag_sock);
        if (this.thread == null || !this.thread.isAlive()) {
            this.thread = this.thread_factory.newThread(this, THREAD_NAME);
            this.thread.setDaemon(true);
            this.thread.start();
        }
    }

    public void stop() {
        if (this.diag_sock != null) {
            this.socket_factory.close(this.diag_sock);
        }
        this.handlers.clear();
        if (this.thread != null) {
            try {
                this.thread.join(300L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void run() {
        byte[] buf = new byte[1500];
        while (!this.diag_sock.isClosed() && Thread.currentThread().equals(this.thread)) {
            DatagramPacket packet = new DatagramPacket(buf, 0, buf.length);
            try {
                this.diag_sock.receive(packet);
                this.handleDiagnosticProbe(packet.getSocketAddress(), this.diag_sock, new String(packet.getData(), packet.getOffset(), packet.getLength()));
            }
            catch (IOException socket_ex) {
            }
            catch (Throwable e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("failure handling diagnostics request", e);
            }
        }
    }

    protected void handleDiagnosticProbe(SocketAddress sender, DatagramSocket sock, String request) {
        StringTokenizer tok = new StringTokenizer(request);
        ArrayList<String> list = new ArrayList<String>(10);
        while (tok.hasMoreTokens()) {
            String req = tok.nextToken().trim();
            if (req.length() <= 0) continue;
            list.add(req);
        }
        String[] tokens = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            tokens[i] = (String)list.get(i);
        }
        for (ProbeHandler handler : this.handlers) {
            Map<String, String> map = handler.handleProbe(tokens);
            if (map == null || map.isEmpty()) continue;
            StringBuilder info = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                info.append(entry.getKey()).append("=").append(entry.getValue()).append("\r\n");
            }
            byte[] diag_rsp = info.toString().getBytes();
            if (this.log.isDebugEnabled()) {
                this.log.debug("sending diag response to " + sender);
            }
            try {
                DiagnosticsHandler.sendResponse(sock, sender, diag_rsp);
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("failed sending diag rsp to " + sender, t);
            }
        }
    }

    protected static void sendResponse(DatagramSocket sock, SocketAddress sender, byte[] buf) throws IOException {
        DatagramPacket p = new DatagramPacket(buf, 0, buf.length, sender);
        sock.send(p);
    }

    protected void bindToInterfaces(List<NetworkInterface> interfaces, MulticastSocket s) {
        InetSocketAddress group_addr = new InetSocketAddress(this.diagnostics_addr, this.diagnostics_port);
        for (NetworkInterface i : interfaces) {
            try {
                if (!i.getInetAddresses().hasMoreElements()) continue;
                s.joinGroup(group_addr, i);
                if (!this.log.isTraceEnabled()) continue;
                this.log.trace("joined " + group_addr + " on " + i.getName());
            }
            catch (IOException e) {
                this.log.warn("failed to join " + group_addr + " on " + i.getName() + ": " + e);
            }
        }
    }

    public static interface ProbeHandler {
        public Map<String, String> handleProbe(String ... var1);

        public String[] supportedKeys();
    }
}

