/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.v3.client.config;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.juddi.v3.client.config.UDDIClientContainer;

public class BackGroundRegistration
implements Runnable {
    private UDDIClerkManager manager = null;
    private static Log log = LogFactory.getLog(BackGroundRegistration.class);

    public BackGroundRegistration(UDDIClerkManager manager) {
        this.manager = manager;
    }

    public void run() {
        try {
            if (UDDIClientContainer.getUDDIClerkManager(this.manager.getName()) != null && this.manager.getClientConfig().isRegisterOnStartup()) {
                log.debug((Object)("Starting UDDI Clerks for manager " + this.manager.getClientConfig().getManagerName() + "..."));
                this.manager.saveClerkAndNodeInfo();
                this.manager.registerAnnotatedServices();
                this.manager.xRegister();
                log.debug((Object)("Clerks started succesfully for manager " + this.manager.getClientConfig().getManagerName()));
            } else {
                log.debug((Object)(this.manager.getName() + " already registered to the UDDIClientContainer."));
            }
        }
        catch (ConfigurationException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }
}

