/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.SpnegoContextToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.Constants;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpnegoContextTokenBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public SpnegoContextTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.SPNEGO_CONTEXT_TOKEN, SP12Constants.SPNEGO_CONTEXT_TOKEN};
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        SpnegoContextToken spnegoContextToken = new SpnegoContextToken(consts);
        spnegoContextToken.setOptional(PolicyConstants.isOptional((Element)element));
        spnegoContextToken.setIgnorable(PolicyConstants.isIgnorable((Element)element));
        String attribute = DOMUtils.getAttribute((Element)element, (QName)consts.getIncludeToken());
        if (attribute == null) {
            throw new IllegalArgumentException("SpnegoContextToken doesn't contain any sp:IncludeToken attribute");
        }
        String inclusionValue = attribute.trim();
        spnegoContextToken.setInclusion(consts.getInclusionFromAttributeValue(inclusionValue));
        Element elem = DOMUtils.getFirstElement((Node)element);
        while (elem != null) {
            QName qn = DOMUtils.getElementQName((Element)elem);
            if (Constants.isPolicyElement((QName)qn)) {
                if (DOMUtils.getFirstChildWithName((Element)elem, (String)consts.getNamespace(), (String)"RequireDerivedKeys") != null) {
                    spnegoContextToken.setDerivedKeys(true);
                } else if (DOMUtils.getFirstChildWithName((Element)elem, (QName)SP12Constants.REQUIRE_IMPLIED_DERIVED_KEYS) != null) {
                    spnegoContextToken.setImpliedDerivedKeys(true);
                } else if (DOMUtils.getFirstChildWithName((Element)elem, (QName)SP12Constants.REQUIRE_EXPLICIT_DERIVED_KEYS) != null) {
                    spnegoContextToken.setExplicitDerivedKeys(true);
                }
            } else if (consts.getNamespace().equals(qn.getNamespaceURI()) && "Issuer".equals(qn.getLocalPart())) {
                spnegoContextToken.setIssuerEpr(DOMUtils.getFirstElement((Node)elem));
            }
            elem = DOMUtils.getNextElement((Element)elem);
        }
        return spnegoContextToken;
    }
}

