/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;

public class SamlToken
extends Token {
    private boolean useSamlVersion11Profile10;
    private boolean useSamlVersion11Profile11;
    private boolean useSamlVersion20Profile11;
    private boolean requireKeyIdentifierReference;

    public SamlToken(SPConstants version) {
        super(version);
    }

    public boolean isUseSamlVersion11Profile10() {
        return this.useSamlVersion11Profile10;
    }

    public void setUseSamlVersion11Profile10(boolean useSamlVersion11Profile10) {
        this.useSamlVersion11Profile10 = useSamlVersion11Profile10;
    }

    public boolean isUseSamlVersion11Profile11() {
        return this.useSamlVersion11Profile11;
    }

    public void setUseSamlVersion11Profile11(boolean useSamlVersion11Profile11) {
        this.useSamlVersion11Profile11 = useSamlVersion11Profile11;
    }

    public boolean isUseSamlVersion20Profile11() {
        return this.useSamlVersion20Profile11;
    }

    public void setUseSamlVersion20Profile11(boolean useSamlVersion20Profile11) {
        this.useSamlVersion20Profile11 = useSamlVersion20Profile11;
    }

    public boolean isRequireKeyIdentifierReference() {
        return this.requireKeyIdentifierReference;
    }

    public void setRequireKeyIdentifierReference(boolean requireKeyIdentifierReference) {
        this.requireKeyIdentifierReference = requireKeyIdentifierReference;
    }

    public QName getName() {
        return SP12Constants.INSTANCE.getSamlToken();
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        QName name = this.constants.getSamlToken();
        String localname = name.getLocalPart();
        String namespaceURI = name.getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = name.getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localname, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        String inclusion = this.constants.getAttributeValueFromInclusion(this.getInclusion());
        if (inclusion != null) {
            writer.writeAttribute(prefix, namespaceURI, "IncludeToken", inclusion);
        }
        if (this.isUseSamlVersion11Profile10() || this.isUseSamlVersion11Profile11() || this.isUseSamlVersion20Profile11()) {
            String pPrefix = writer.getPrefix(SPConstants.POLICY.getNamespaceURI());
            if (pPrefix == null) {
                pPrefix = SPConstants.POLICY.getPrefix();
                writer.setPrefix(SPConstants.POLICY.getPrefix(), SPConstants.POLICY.getNamespaceURI());
            }
            writer.writeStartElement(pPrefix, SPConstants.POLICY.getLocalPart(), SPConstants.POLICY.getNamespaceURI());
            if (this.isUseSamlVersion11Profile10()) {
                writer.writeStartElement(prefix, "WssSamlV11Token10", namespaceURI);
            } else if (this.isUseSamlVersion11Profile11()) {
                writer.writeStartElement(prefix, "WssSamlV11Token11", namespaceURI);
            } else {
                writer.writeStartElement(prefix, "WssSamlV20Token11", namespaceURI);
            }
            if (this.isDerivedKeys()) {
                writer.writeStartElement(prefix, "RequireDerivedKeys", namespaceURI);
                writer.writeEndElement();
            } else if (this.isExplicitDerivedKeys()) {
                writer.writeStartElement(prefix, "RequireExplicitDerivedKeys", namespaceURI);
                writer.writeEndElement();
            } else if (this.isImpliedDerivedKeys()) {
                writer.writeStartElement(prefix, "RequireImpliedDerivedKeys", namespaceURI);
                writer.writeEndElement();
            }
            if (this.isRequireKeyIdentifierReference()) {
                writer.writeStartElement(prefix, "RequireKeyIdentifierReference", namespaceURI);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

