/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.jcr;

import org.chromattic.api.ChromatticSession;
import org.chromattic.api.format.FormatterContext;
import org.chromattic.api.format.ObjectFormatter;
import org.gatein.wsrp.jcr.StoresByPathManager;

public interface ChromatticPersister {
    public ChromatticSession getSession();

    public void closeSession(boolean var1);

    public void save();

    public <T> boolean delete(T var1, StoresByPathManager<T> var2);

    public boolean isSessionClosed();

    public static class PortletNameFormatter
    implements ObjectFormatter {
        public static final String SLASH_REPLACEMENT = "-_-";
        private static final String SLASH = "/";

        public String decodeNodeName(FormatterContext formatterContext, String s) {
            return PortletNameFormatter.decode(s);
        }

        public static String decode(String s) {
            return s.replace(SLASH_REPLACEMENT, SLASH);
        }

        public String encodeNodeName(FormatterContext formatterContext, String s) throws IllegalArgumentException, NullPointerException {
            return PortletNameFormatter.encode(s);
        }

        public static String encode(String s) {
            return s.replace(SLASH, SLASH_REPLACEMENT);
        }
    }

    public static class QNameFormatter
    implements ObjectFormatter {
        private static final String OPEN_BRACE_REPLACEMENT = "-__";
        private static final String CLOSE_BRACE_REPLACEMENT = "__-";
        private static final String COLON_REPLACEMENT = "_-_";
        private static final String CLOSE_BRACE = "}";
        private static final String OPEN_BRACE = "{";
        private static final String COLON = ":";

        public String decodeNodeName(FormatterContext formatterContext, String s) {
            return QNameFormatter.decode(s);
        }

        public String encodeNodeName(FormatterContext formatterContext, String s) {
            return QNameFormatter.encode(s);
        }

        public String decodePropertyName(FormatterContext formatterContext, String s) {
            return QNameFormatter.decode(s);
        }

        public String encodePropertyName(FormatterContext formatterContext, String s) {
            return QNameFormatter.encode(s);
        }

        public static String decode(String s) {
            return s.replace(CLOSE_BRACE_REPLACEMENT, CLOSE_BRACE).replace(OPEN_BRACE_REPLACEMENT, OPEN_BRACE).replace(COLON_REPLACEMENT, COLON);
        }

        public static String encode(String s) {
            return s.replace(OPEN_BRACE, OPEN_BRACE_REPLACEMENT).replace(CLOSE_BRACE, CLOSE_BRACE_REPLACEMENT).replace(COLON, COLON_REPLACEMENT);
        }
    }
}

