/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.jcr.mapping;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gatein.common.util.ParameterValidation;
import org.gatein.common.util.Tools;

public class MappedMap<Key, Value> {
    private static final Set<String> jcrBlacklistedPropertyKeys = Tools.toSet((Object[])new String[]{"jcr:uuid", "jcr:primaryType"});
    private Set<String> blacklistedPropertyKeys;
    private Converter<String, Key> keyConverter;
    private Converter<Object, Value> valueConverter;
    public static final Converter<String, String> IDENTITY_KEY_CONVERTER = new Converter<String, String>(){

        @Override
        public String fromInternal(String s) {
            return s;
        }

        @Override
        public String toInternal(String s) {
            return s;
        }
    };

    public MappedMap(Converter<String, Key> keyConverter, Converter<Object, Value> valueConverter, String ... blacklistedPropertyNames) {
        this.keyConverter = keyConverter;
        this.valueConverter = valueConverter;
        int blacklistedNumber = blacklistedPropertyNames.length;
        if (blacklistedNumber > 0) {
            this.blacklistedPropertyKeys = new HashSet<String>(jcrBlacklistedPropertyKeys);
            this.blacklistedPropertyKeys.addAll(Arrays.asList(blacklistedPropertyNames));
        }
    }

    public Map<Key, Value> toExternalMap(Map<String, Object> internalMap) {
        if (!internalMap.isEmpty()) {
            HashMap<Key, Value> externalMap = new HashMap<Key, Value>(internalMap.size());
            for (Map.Entry<String, Object> entry : internalMap.entrySet()) {
                String key = entry.getKey();
                if (this.blacklistedPropertyKeys.contains(key)) continue;
                externalMap.put(this.keyConverter.fromInternal(key), this.valueConverter.fromInternal(entry.getValue()));
            }
            return externalMap;
        }
        return Collections.emptyMap();
    }

    public void initFrom(Map<Key, Value> externalMap, Map<String, Object> internalMap) {
        if (ParameterValidation.existsAndIsNotEmpty(externalMap)) {
            HashSet<String> keys = new HashSet<String>(internalMap.keySet());
            for (String string : keys) {
                if (this.blacklistedPropertyKeys.contains(string)) continue;
                internalMap.remove(string);
            }
            for (Map.Entry entry : externalMap.entrySet()) {
                internalMap.put(this.keyConverter.toInternal(entry.getKey()), this.valueConverter.toInternal(entry.getValue()));
            }
        }
    }

    public static interface Converter<Internal, External> {
        public External fromInternal(Internal var1);

        public Internal toInternal(External var1);
    }
}

