/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config.mapping;

import org.chromattic.api.annotations.MappedBy;
import org.chromattic.api.annotations.OneToOne;
import org.chromattic.api.annotations.Owner;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.wsrp.jcr.mapping.BaseMapping;
import org.gatein.wsrp.jcr.mapping.mixins.LastModifiedMixinHolder;
import org.gatein.wsrp.producer.config.ProducerConfiguration;
import org.gatein.wsrp.producer.config.ProducerConfigurationService;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.producer.config.impl.ProducerConfigurationImpl;
import org.gatein.wsrp.producer.config.mapping.RegistrationRequirementsMapping;

@PrimaryType(name="wsrp:producerconfiguration")
public abstract class ProducerConfigurationMapping
extends LastModifiedMixinHolder
implements BaseMapping<ProducerConfiguration, ProducerConfigurationService> {
    public static final String NODE_NAME = "wsrp:producerconfiguration";

    @Property(name="strictmode")
    public abstract boolean getUsingStrictMode();

    public abstract void setUsingStrictMode(boolean var1);

    @OneToOne
    @Owner
    @MappedBy(value="registrationrequirements")
    public abstract RegistrationRequirementsMapping getRegistrationRequirements();

    @Override
    public void initFrom(ProducerConfiguration configuration) {
        this.setUsingStrictMode(configuration.isUsingStrictMode());
        this.setLastModified(configuration.getLastModified());
        RegistrationRequirementsMapping rrm = this.getRegistrationRequirements();
        rrm.initFrom(configuration.getRegistrationRequirements());
    }

    @Override
    public ProducerConfiguration toModel(ProducerConfiguration initial, ProducerConfigurationService registry) {
        ProducerConfiguration configuration = initial;
        if (initial == null) {
            configuration = new ProducerConfigurationImpl();
        }
        configuration.setUsingStrictMode(this.getUsingStrictMode());
        configuration.setLastModified(this.getLastModified());
        ProducerRegistrationRequirements req = this.getRegistrationRequirements().toModel(configuration.getRegistrationRequirements(), registry);
        configuration.setRegistrationRequirements(req);
        return configuration;
    }

    @Override
    public Class<ProducerConfiguration> getModelClass() {
        return ProducerConfiguration.class;
    }
}

