/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer.config.mapping;

import java.util.List;
import org.chromattic.api.annotations.Create;
import org.chromattic.api.annotations.FindById;
import org.chromattic.api.annotations.OneToMany;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.registration.RegistrationPolicy;
import org.gatein.registration.policies.DefaultRegistrationPolicy;
import org.gatein.registration.policies.RegistrationPolicyWrapper;
import org.gatein.wsrp.jcr.mapping.BaseMapping;
import org.gatein.wsrp.jcr.mapping.mixins.LastModifiedMixinHolder;
import org.gatein.wsrp.producer.config.ProducerConfigurationService;
import org.gatein.wsrp.producer.config.ProducerRegistrationRequirements;
import org.gatein.wsrp.producer.config.impl.ProducerRegistrationRequirementsImpl;
import org.gatein.wsrp.registration.RegistrationPropertyDescription;
import org.gatein.wsrp.registration.mapping.RegistrationPropertyDescriptionMapping;

@PrimaryType(name="wsrp:registrationrequirements")
public abstract class RegistrationRequirementsMapping
extends LastModifiedMixinHolder
implements BaseMapping<ProducerRegistrationRequirements, ProducerConfigurationService> {
    public static final String NODE_NAME = "wsrp:registrationrequirements";

    @Property(name="registrationrequired")
    public abstract boolean getRegistrationRequired();

    public abstract void setRegistrationRequired(boolean var1);

    @Property(name="registrationrequiredforfulldescription")
    public abstract boolean getRegistrationRequiredForFullDescription();

    public abstract void setRegistrationRequiredForFullDescription(boolean var1);

    @Property(name="policyclassname")
    public abstract String getPolicyClassName();

    public abstract void setPolicyClassName(String var1);

    @Property(name="validatorclassname")
    public abstract String getValidatorClassName();

    public abstract void setValidatorClassName(String var1);

    @OneToMany
    public abstract List<RegistrationPropertyDescriptionMapping> getRegistrationPropertyDescriptions();

    @Create
    public abstract RegistrationPropertyDescriptionMapping createRegistrationPropertyDescription(String var1);

    @FindById
    public abstract RegistrationPropertyDescriptionMapping findRegistrationPropertyDescriptionById(String var1);

    @Override
    public void initFrom(ProducerRegistrationRequirements registrationRequirements) {
        this.setRegistrationRequired(registrationRequirements.isRegistrationRequired());
        this.setRegistrationRequiredForFullDescription(registrationRequirements.isRegistrationRequiredForFullDescription());
        RegistrationPolicy policy = registrationRequirements.getPolicy();
        if (policy != null) {
            this.setPolicyClassName(policy.getClassName());
            RegistrationPolicy unwrap = RegistrationPolicyWrapper.unwrap((RegistrationPolicy)policy);
            if (unwrap instanceof DefaultRegistrationPolicy) {
                DefaultRegistrationPolicy drp = (DefaultRegistrationPolicy)unwrap;
                this.setValidatorClassName(drp.getValidator().getClass().getName());
            }
        }
        List<RegistrationPropertyDescriptionMapping> rpdms = this.getRegistrationPropertyDescriptions();
        rpdms.clear();
        for (RegistrationPropertyDescription desc : registrationRequirements.getRegistrationProperties().values()) {
            RegistrationPropertyDescriptionMapping rpdm = this.createRegistrationPropertyDescription(desc.getNameAsString());
            rpdms.add(rpdm);
            rpdm.initFrom(desc);
        }
        this.setLastModified(registrationRequirements.getLastModified());
    }

    @Override
    public ProducerRegistrationRequirements toModel(ProducerRegistrationRequirements initial, ProducerConfigurationService registry) {
        ProducerRegistrationRequirements req = initial;
        if (initial == null) {
            req = new ProducerRegistrationRequirementsImpl();
        }
        req.setRegistrationRequired(this.getRegistrationRequired());
        req.setRegistrationRequiredForFullDescription(this.getRegistrationRequiredForFullDescription());
        req.reloadPolicyFrom(this.getPolicyClassName(), this.getValidatorClassName());
        for (RegistrationPropertyDescriptionMapping rpdm : this.getRegistrationPropertyDescriptions()) {
            req.addRegistrationProperty(rpdm.toRegistrationPropertyDescription());
        }
        req.setLastModified(this.getLastModified());
        return req;
    }

    @Override
    public Class<ProducerRegistrationRequirements> getModelClass() {
        return ProducerRegistrationRequirements.class;
    }
}

