/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.registration.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.chromattic.api.annotations.PrimaryType;
import org.chromattic.api.annotations.Property;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.WindowState;
import org.gatein.registration.ConsumerCapabilities;
import org.gatein.registration.impl.ConsumerCapabilitiesImpl;

@PrimaryType(name="wsrp:consumercapabilities")
public abstract class ConsumerCapabilitiesMapping {
    public static final String NODE_NAME = "wsrp:consumercapabilities";

    @Property(name="supportsgetmethod")
    public abstract boolean getSupportsGetMethod();

    public abstract void setSupportsGetMethod(boolean var1);

    @Property(name="modes")
    public abstract List<String> getSupportedModes();

    public abstract void setSupportedModes(List<String> var1);

    @Property(name="windowstates")
    public abstract List<String> getSupportedWindowStates();

    public abstract void setSupportedWindowStates(List<String> var1);

    @Property(name="userscopes")
    public abstract List<String> getSupportedUserScopes();

    public abstract void setSupportedUserScopes(List<String> var1);

    @Property(name="userprofiledata")
    public abstract List<String> getSupportedUserProfileData();

    public abstract void setSupportedUserProfileData(List<String> var1);

    public void initFrom(ConsumerCapabilities capabilities) {
        List userProfileData;
        List scopes;
        List<String> states;
        this.setSupportsGetMethod(capabilities.supportsGetMethod());
        List<String> modes = this.convertToStringList(capabilities.getSupportedModes());
        if (modes != null) {
            this.setSupportedModes(modes);
        }
        if ((states = this.convertToStringList(capabilities.getSupportedWindowStates())) != null) {
            this.setSupportedWindowStates(states);
        }
        if (ParameterValidation.existsAndIsNotEmpty((Collection)(scopes = capabilities.getSupportedUserScopes()))) {
            this.setSupportedUserScopes(scopes);
        }
        if (ParameterValidation.existsAndIsNotEmpty((Collection)(userProfileData = capabilities.getSupportedUserProfileData()))) {
            this.setSupportedUserProfileData(userProfileData);
        }
    }

    private List<String> convertToStringList(List list) {
        if (ParameterValidation.existsAndIsNotEmpty((Collection)list)) {
            ArrayList<String> result = new ArrayList<String>(list.size());
            for (Object object : list) {
                result.add(object.toString());
            }
            return result;
        }
        return null;
    }

    public ConsumerCapabilities toConsumerCapabilities() {
        List<String> userScopes;
        List<String> userProfileData;
        List<String> windowStateStrings;
        ConsumerCapabilitiesImpl consumerCapabilities = new ConsumerCapabilitiesImpl();
        consumerCapabilities.setSupportsGetMethod(this.getSupportsGetMethod());
        List<String> modeStrings = this.getSupportedModes();
        if (ParameterValidation.existsAndIsNotEmpty(modeStrings)) {
            ArrayList<Mode> modes = new ArrayList<Mode>(modeStrings.size());
            for (String modeString : modeStrings) {
                modes.add(Mode.create((String)modeString));
            }
            consumerCapabilities.setSupportedModes(modes);
        }
        if (ParameterValidation.existsAndIsNotEmpty(windowStateStrings = this.getSupportedWindowStates())) {
            ArrayList<WindowState> windowStates = new ArrayList<WindowState>(windowStateStrings.size());
            for (String windowStateString : windowStateStrings) {
                windowStates.add(WindowState.create((String)windowStateString));
            }
            consumerCapabilities.setSupportedWindowStates(windowStates);
        }
        if (ParameterValidation.existsAndIsNotEmpty(userProfileData = this.getSupportedUserProfileData())) {
            consumerCapabilities.setSupportedUserProfileData(userProfileData);
        }
        if (ParameterValidation.existsAndIsNotEmpty(userScopes = this.getSupportedUserScopes())) {
            consumerCapabilities.setSupportedUserScopes(userScopes);
        }
        return consumerCapabilities;
    }
}

