/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.validator;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.richfaces.application.ServiceTracker;
import org.richfaces.validator.BeanValidatorService;
import org.richfaces.validator.GraphValidator;

public class FacesBeanValidator
implements Serializable,
Validator,
GraphValidator {
    public static final String BEAN_VALIDATOR_TYPE = "org.richfaces.BeanValidator";
    private static final long serialVersionUID = -264568176252121853L;
    private ValueExpression summaryExpression = null;
    private String summary = null;
    private ValueExpression groupsExpression = null;
    private Class<?>[] groups = null;
    private boolean validateFields = true;

    public String getSummary() {
        String summaryString = null;
        summaryString = null != this.summaryExpression ? (String)this.summaryExpression.getValue(FacesContext.getCurrentInstance().getELContext()) : this.summary;
        return summaryString;
    }

    public void setSummary(ValueExpression summary) {
        this.summaryExpression = summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public void validate(FacesContext context, UIComponent component, Object convertedValue) throws ValidatorException {
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            try {
                ValueExpression valueExpression = component.getValueExpression("value");
                if (null != valueExpression) {
                    BeanValidatorService validatorService = (BeanValidatorService)ServiceTracker.getService(BeanValidatorService.class);
                    Collection messages = validatorService.validateExpression(context, valueExpression, convertedValue, (Class[])this.getGroups());
                    if (this.isValidateFields() && !messages.isEmpty()) {
                        input.setValid(false);
                        Object label = FacesBeanValidator.getLabel(context, component);
                        Locale locale = context.getViewRoot().getLocale();
                        for (String msg : messages) {
                            String formattedMessage = FacesBeanValidator.formatMessage(msg, locale, label, convertedValue);
                            String summary = this.getSummary();
                            String formattedSummary = Strings.isNullOrEmpty((String)summary) ? formattedMessage : FacesBeanValidator.formatMessage(summary, locale, label, convertedValue);
                            context.addMessage(component.getClientId(context), new FacesMessage(FacesMessage.SEVERITY_ERROR, formattedSummary, formattedMessage));
                        }
                    }
                }
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
    }

    static String formatMessage(String msg, Locale locale, Object ... messageParams) {
        if (msg.contains("{")) {
            try {
                MessageFormat messageFormat = new MessageFormat(msg, locale);
                msg = messageFormat.format(messageParams);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return msg;
    }

    static Object getLabel(FacesContext context, UIComponent component) {
        Object label = component.getAttributes().get("label");
        if (null == label || 0 == label.toString().length()) {
            label = component.getClientId(context);
        }
        return label;
    }

    public Collection<String> validateGraph(FacesContext context, UIComponent component, Object value, Class<?>[] groups) throws ValidatorException {
        BeanValidatorService validatorService = (BeanValidatorService)ServiceTracker.getService(BeanValidatorService.class);
        Collection messages = validatorService.validateObject(context, value, (Class[])groups);
        return messages;
    }

    public Class<?>[] getGroups() {
        Class<Object>[] profiles = null != this.groupsExpression ? (Class[])this.groupsExpression.getValue(FacesContext.getCurrentInstance().getELContext()) : this.groups;
        return profiles;
    }

    public void setGroups(Class<?> ... profiles) {
        this.groups = profiles;
    }

    public void setGroups(ValueExpression profilesExpression) {
        this.groupsExpression = profilesExpression;
    }

    public boolean isValidateFields() {
        return this.validateFields;
    }

    public void setValidateFields(boolean ignoreErrors) {
        this.validateFields = ignoreErrors;
    }
}

