/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.PatternSyntaxException;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.management.api.ManagedDescription;
import org.gatein.management.api.ManagedResource;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.PathAddressIterator;
import org.gatein.management.api.PathTemplateResolver;
import org.gatein.management.api.exceptions.ManagementException;
import org.gatein.management.api.operation.OperationHandler;
import org.gatein.management.core.api.AbstractManagedResource;
import org.gatein.management.core.api.PathElement;

public class SimpleManagedResource
extends AbstractManagedResource {
    private static final Logger log = LoggerFactory.getLogger(SimpleManagedResource.class);
    private volatile ConcurrentMap<String, SimpleManagedResource> children = new ConcurrentHashMap<String, SimpleManagedResource>();
    private volatile ConcurrentMap<String, AbstractManagedResource.OperationEntry> operations = new ConcurrentHashMap<String, AbstractManagedResource.OperationEntry>();
    protected final ManagedDescription description;

    public SimpleManagedResource(PathElement pathElement, AbstractManagedResource parent, ManagedDescription description) {
        super(pathElement, parent);
        this.description = description;
    }

    public ManagedResource.Registration registerSubResource(String name, ManagedDescription description) {
        PathElement element;
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (description == null) {
            throw new IllegalArgumentException("description is null");
        }
        if (name.startsWith("/")) {
            name = name.substring(1, name.length());
        }
        try {
            element = PathElement.pathElement(name);
        }
        catch (PatternSyntaxException e) {
            throw new ManagementException("Could not parse path template " + name, (Throwable)e);
        }
        SimpleManagedResource resource = new SimpleManagedResource(element, this, description);
        if (this.children.putIfAbsent(element.getValue(), resource) != null) {
            throw new IllegalArgumentException("Resource " + name + " already exists for path " + this.getPath());
        }
        return resource;
    }

    public void registerOperationHandler(String operationName, OperationHandler operationHandler, ManagedDescription description) {
        this.registerOperationHandler(operationName, operationHandler, description, false);
    }

    public void registerOperationHandler(String operationName, OperationHandler operationHandler, ManagedDescription description, boolean inherited) {
        if (this.operations.putIfAbsent(operationName, new AbstractManagedResource.OperationEntry(operationHandler, description, inherited)) != null) {
            throw new IllegalArgumentException("A handler is already registered for operation " + operationName + " at path " + this.getPath());
        }
    }

    @Override
    protected ManagedDescription getResourceDescription(PathAddressIterator iterator) {
        if (iterator.hasNext()) {
            String name = iterator.next();
            AbstractManagedResource resource = this.findDescendant(iterator, name, new StringBuilder());
            return resource != null ? resource.getResourceDescription(iterator) : null;
        }
        return this.description;
    }

    @Override
    protected AbstractManagedResource.OperationEntry getOperationEntry(PathAddressIterator iterator, String operationName) {
        if (operationName == null) {
            return null;
        }
        AbstractManagedResource.OperationEntry entry = (AbstractManagedResource.OperationEntry)this.operations.get(operationName);
        if (iterator.hasNext()) {
            String name = iterator.next();
            AbstractManagedResource resource = this.findDescendant(iterator, name, new StringBuilder());
            return resource != null ? resource.getOperationEntry(iterator, operationName) : null;
        }
        if (entry == null) {
            AbstractManagedResource parent = this.parent;
            while (parent != null) {
                AbstractManagedResource.OperationEntry parentEntry = parent.getOperationEntry(PathAddressIterator.EMPTY, operationName);
                if (parentEntry != null && parentEntry.isInherited()) {
                    entry = parentEntry;
                    break;
                }
                parent = parent.parent;
            }
        }
        return entry;
    }

    @Override
    protected void getOperationEntries(PathAddressIterator iterator, Map<String, AbstractManagedResource.OperationEntry> entries) {
        if (iterator.hasNext()) {
            String name = iterator.next();
            AbstractManagedResource resource = this.findDescendant(iterator, name, new StringBuilder());
            if (resource != null) {
                resource.getOperationEntries(iterator, entries);
            }
        } else {
            for (Map.Entry entry : this.operations.entrySet()) {
                entries.put((String)entry.getKey(), (AbstractManagedResource.OperationEntry)entry.getValue());
            }
            AbstractManagedResource parent = this.parent;
            while (parent != null) {
                HashMap<String, AbstractManagedResource.OperationEntry> parentMap = new HashMap<String, AbstractManagedResource.OperationEntry>();
                parent.getOperationEntries(PathAddress.empty().iterator(), parentMap);
                for (Map.Entry entry : parentMap.entrySet()) {
                    if (!((AbstractManagedResource.OperationEntry)entry.getValue()).isInherited() || entries.containsKey(entry.getKey())) continue;
                    entries.put((String)entry.getKey(), (AbstractManagedResource.OperationEntry)entry.getValue());
                }
                parent = parent.parent;
            }
        }
    }

    @Override
    protected AbstractManagedResource getSubResource(PathAddressIterator iterator) {
        if (iterator.hasNext()) {
            String name = iterator.next();
            AbstractManagedResource resource = this.findDescendant(iterator, name, new StringBuilder());
            return resource != null ? resource.getSubResource(iterator) : null;
        }
        return this;
    }

    public ManagedResource getSubResource(String childName) {
        return (ManagedResource)this.children.get(childName);
    }

    @Override
    protected Set<String> getChildNames(PathAddressIterator iterator) {
        if (iterator.hasNext()) {
            String name = iterator.next();
            AbstractManagedResource resource = this.findDescendant(iterator, name, new StringBuilder());
            return resource == null ? Collections.emptySet() : resource.getChildNames(iterator);
        }
        return Collections.unmodifiableSet(new HashSet(this.children.keySet()));
    }

    private AbstractManagedResource findDescendant(PathAddressIterator iterator, String childName, StringBuilder path) {
        AbstractManagedResource child = (AbstractManagedResource)this.children.get(childName);
        while (child == null) {
            path.append("/").append(childName);
            child = this.findMatch(iterator, path);
            if (!iterator.hasNext()) break;
            child = this.findDescendant(iterator, iterator.next(), path);
        }
        return child;
    }

    private AbstractManagedResource findMatch(PathAddressIterator iterator, StringBuilder path) {
        for (SimpleManagedResource resource : this.children.values()) {
            if (!resource.pathElement.matches(path.toString())) continue;
            PathAddressIterator pai = new PathAddressIterator(iterator.currentAddress());
            StringBuilder sb = new StringBuilder(path);
            while (pai.hasNext()) {
                AbstractManagedResource found;
                String next = pai.next();
                sb.append("/").append(next);
                if (!resource.pathElement.matches(sb.toString()) || (found = resource.findMatch(pai, new StringBuilder(next))) != null) break;
                path.append("/").append(next);
                iterator.next();
            }
            iterator.originalAddress().addPathTemplateResolver((PathTemplateResolver)new PathTemplateResolverImpl(resource.pathElement, path.toString()));
            if (iterator.hasNext()) {
                pai = new PathAddressIterator(iterator.currentAddress().copy());
                AbstractManagedResource subResource = resource.getSubResource(pai);
                if (subResource == null) continue;
                PathAddress address = pai.originalAddress();
                for (PathTemplateResolver resolver : address.getPathTemplateResolvers()) {
                    iterator.originalAddress().addPathTemplateResolver(resolver);
                }
                while (iterator.hasNext()) {
                    iterator.next();
                }
                return subResource;
            }
            return resource;
        }
        return null;
    }

    private static class PathTemplateResolverImpl
    implements PathTemplateResolver {
        private PathElement pathElement;
        private String path;

        public PathTemplateResolverImpl(PathElement pathElement, String path) {
            this.pathElement = pathElement;
            this.path = path;
        }

        public String resolve(String templateName) {
            return this.pathElement.resolve(templateName, this.path);
        }
    }
}

