/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.management.core.api.operation;

import java.io.InputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import org.gatein.management.api.ContentType;
import org.gatein.management.api.ManagedResource;
import org.gatein.management.api.PathAddress;
import org.gatein.management.api.RuntimeContext;
import org.gatein.management.api.binding.BindingProvider;
import org.gatein.management.api.controller.ManagedRequest;
import org.gatein.management.api.operation.OperationAttachment;
import org.gatein.management.api.operation.OperationAttributes;
import org.gatein.management.api.operation.OperationContext;
import org.gatein.management.core.api.operation.OperationAttributesImpl;

public class OperationContextImpl
implements OperationContext {
    private final ManagedRequest request;
    private final ManagedResource resource;
    private final RuntimeContext runtimeContext;
    private final BindingProvider bindingProvider;
    private final Deque<OperationAttachment> attachments;
    private final OperationAttributes attributes;

    public OperationContextImpl(final ManagedRequest request, ManagedResource resource, RuntimeContext runtimeContext, BindingProvider bindingProvider) {
        ArrayDeque<OperationAttachment> list = new ArrayDeque<OperationAttachment>();
        list.push(new OperationAttachment(){

            public InputStream getStream() {
                return request.getDataStream();
            }
        });
        this.request = request;
        this.resource = resource;
        this.runtimeContext = runtimeContext;
        this.bindingProvider = bindingProvider;
        this.attachments = list;
        this.attributes = new OperationAttributesImpl(request.getAttributes());
    }

    public ManagedResource getManagedResource() {
        return this.resource;
    }

    public PathAddress getAddress() {
        return this.request.getAddress();
    }

    public String getOperationName() {
        return this.request.getOperationName();
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public OperationAttributes getAttributes() {
        return this.attributes;
    }

    public OperationAttachment getAttachment(boolean remove) {
        if (remove) {
            return this.attachments.pop();
        }
        return this.attachments.peek();
    }

    public BindingProvider getBindingProvider() {
        return this.bindingProvider;
    }

    public ContentType getContentType() {
        return this.request.getContentType();
    }
}

