/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jgroups.Event;
import org.jgroups.UpHandler;

public class ClassLoaderAwareUpHandler
implements UpHandler {
    private final UpHandler handler;
    private final WeakReference<ClassLoader> loaderRef;

    public ClassLoaderAwareUpHandler(UpHandler handler) {
        this(handler, ClassLoaderAwareUpHandler.getContextClassLoader());
    }

    public ClassLoaderAwareUpHandler(UpHandler handler, ClassLoader loader) {
        this.handler = handler;
        this.loaderRef = new WeakReference<ClassLoader>(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object up(Event event) {
        ClassLoader loader = (ClassLoader)this.loaderRef.get();
        ClassLoader contextLoader = ClassLoaderAwareUpHandler.getContextClassLoader();
        if (loader != null) {
            ClassLoaderAwareUpHandler.setContextClassLoader(loader);
        }
        try {
            Object object = this.handler.up(event);
            return object;
        }
        finally {
            if (loader != null) {
                ClassLoaderAwareUpHandler.setContextClassLoader(contextLoader);
            }
        }
    }

    private static ClassLoader getContextClassLoader() {
        PrivilegedAction<ClassLoader> action = new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        return AccessController.doPrivileged(action);
    }

    private static void setContextClassLoader(final ClassLoader loader) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(loader);
                return null;
            }
        };
        AccessController.doPrivileged(action);
    }
}

