/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups;

import org.jboss.as.clustering.jgroups.ClassLoaderAwareUpHandler;
import org.jgroups.Event;
import org.jgroups.JChannel;
import org.jgroups.UpHandler;
import org.jgroups.blocks.mux.MuxUpHandler;
import org.jgroups.blocks.mux.Muxer;
import org.jgroups.conf.ProtocolStackConfigurator;

public class MuxChannel
extends JChannel {
    public MuxChannel(ProtocolStackConfigurator configurator) throws Exception {
        super(configurator);
        this.setUpHandler((UpHandler)new ClassLoaderAwareMuxUpHandler());
    }

    public void setUpHandler(UpHandler handler) {
        UpHandler existingHandler = this.getUpHandler();
        if (existingHandler != null && existingHandler instanceof Muxer) {
            Muxer muxer = (Muxer)existingHandler;
            muxer.setDefaultHandler((Object)handler);
        } else {
            super.setUpHandler(handler);
        }
    }

    private static class ClassLoaderAwareMuxUpHandler
    extends MuxUpHandler {
        private ClassLoaderAwareMuxUpHandler() {
        }

        public void add(short id, UpHandler handler) {
            super.add(id, this.getUpHandler(handler));
        }

        public Object up(Event event) {
            return super.up(event);
        }

        public void setDefaultHandler(UpHandler handler) {
            super.setDefaultHandler(this.getUpHandler(handler));
        }

        private UpHandler getUpHandler(UpHandler handler) {
            return handler instanceof ClassLoaderAwareUpHandler ? handler : new ClassLoaderAwareUpHandler(handler);
        }
    }
}

