/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.HashMap;
import java.util.Map;

public enum Protocol {
    UNKNOWN(null),
    UDP("UDP"),
    TCP("TCP"),
    TCP_GOSSIP("TCP_GOSSIP"),
    AUTH("AUTH"),
    PING("PING"),
    MPING("MPING"),
    MERGE2("MERGE2"),
    FD_SOCK("FD_SOCK"),
    FD("FD"),
    VERIFY_SUSPECT("VERIFY_SUSPECT"),
    BARRIER("BARRIER"),
    NAKACK("pbcast.NAKACK"),
    UNICAST2("UNICAST2"),
    STABLE("pbcast.STABLE"),
    GMS("pbcast.GMS"),
    UFC("UFC"),
    MFC("MFC"),
    FRAG2("FRAG2"),
    STATE_TRANSFER("pbcast.STATE_TRANSFER"),
    FLUSH("pbcast.FLUSH");

    private final String name;
    private static final Map<String, Protocol> elements;

    private Protocol(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Protocol forName(String localName) {
        Protocol element = elements.get(localName);
        return element == null ? UNKNOWN : element;
    }

    static {
        HashMap<String, Protocol> map = new HashMap<String, Protocol>();
        for (Protocol element : Protocol.values()) {
            String name = element.getLocalName();
            if (name == null) continue;
            map.put(name, element);
        }
        elements = map;
    }
}

