/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool;

import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;

public abstract class BaseObjectPool
implements ObjectPool {
    private volatile boolean closed = false;

    @Override
    public abstract Object borrowObject() throws Exception;

    @Override
    public abstract void returnObject(Object var1) throws Exception;

    @Override
    public abstract void invalidateObject(Object var1) throws Exception;

    @Override
    public int getNumIdle() throws UnsupportedOperationException {
        return -1;
    }

    @Override
    public int getNumActive() throws UnsupportedOperationException {
        return -1;
    }

    @Override
    public void clear() throws Exception, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addObject() throws Exception, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws Exception {
        this.closed = true;
    }

    @Override
    public void setFactory(PoolableObjectFactory factory) throws IllegalStateException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public final boolean isClosed() {
        return this.closed;
    }

    protected final void assertOpen() throws IllegalStateException {
        if (this.isClosed()) {
            throw new IllegalStateException("Pool not open");
        }
    }
}

