/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool.impl;

import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.StackKeyedObjectPool;

public class StackKeyedObjectPoolFactory
implements KeyedObjectPoolFactory {
    protected KeyedPoolableObjectFactory _factory = null;
    protected int _maxSleeping = 8;
    protected int _initCapacity = 4;

    public StackKeyedObjectPoolFactory() {
        this(null, 8, 4);
    }

    public StackKeyedObjectPoolFactory(int maxSleeping) {
        this(null, maxSleeping, 4);
    }

    public StackKeyedObjectPoolFactory(int maxSleeping, int initialCapacity) {
        this(null, maxSleeping, initialCapacity);
    }

    public StackKeyedObjectPoolFactory(KeyedPoolableObjectFactory factory) {
        this(factory, 8, 4);
    }

    public StackKeyedObjectPoolFactory(KeyedPoolableObjectFactory factory, int maxSleeping) {
        this(factory, maxSleeping, 4);
    }

    public StackKeyedObjectPoolFactory(KeyedPoolableObjectFactory factory, int maxSleeping, int initialCapacity) {
        this._factory = factory;
        this._maxSleeping = maxSleeping;
        this._initCapacity = initialCapacity;
    }

    @Override
    public KeyedObjectPool createPool() {
        return new StackKeyedObjectPool(this._factory, this._maxSleeping, this._initCapacity);
    }

    public KeyedPoolableObjectFactory getFactory() {
        return this._factory;
    }

    public int getMaxSleeping() {
        return this._maxSleeping;
    }

    public int getInitialCapacity() {
        return this._initCapacity;
    }
}

