/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers;

import java.io.UnsupportedEncodingException;
import java.util.LinkedHashMap;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.handlers.FormatterSpec;
import org.jboss.as.logging.handlers.HandlerService;
import org.jboss.as.logging.util.LogServices;
import org.jboss.as.logging.util.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public abstract class AbstractLogHandlerWriteAttributeHandler<S extends HandlerService<?>>
extends AbstractWriteAttributeHandler<S> {
    public static final AttributeDefinition[] DEFAULT_ATTRIBUTES = new AttributeDefinition[]{CommonAttributes.LEVEL, CommonAttributes.FILTER, CommonAttributes.FORMATTER, CommonAttributes.ENCODING, CommonAttributes.FILTER};
    private final AttributeDefinition[] attributes;

    protected AbstractLogHandlerWriteAttributeHandler(AttributeDefinition ... attributes) {
        super(AbstractLogHandlerWriteAttributeHandler.joinUnique(attributes, DEFAULT_ATTRIBUTES));
        this.attributes = AbstractLogHandlerWriteAttributeHandler.joinUnique(attributes, DEFAULT_ATTRIBUTES);
    }

    protected final boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<S> handbackHolder) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String name = address.getLastElement().getValue();
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        ServiceController controller = serviceRegistry.getService(LogServices.handlerName(name));
        if (controller == null) {
            return false;
        }
        HandlerService handlerService = (HandlerService)controller.getService();
        if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
            handlerService.setLevel(ModelParser.parseLevel(resolvedValue));
        } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
            handlerService.setFilter(ModelParser.parseFilter(context, resolvedValue));
        } else if (CommonAttributes.FORMATTER.getName().equals(attributeName)) {
            handlerService.setFormatterSpec(FormatterSpec.fromModelNode(context, resolvedValue));
        } else if (CommonAttributes.ENCODING.getName().equals(attributeName)) {
            try {
                handlerService.setEncoding(resolvedValue.asString());
            }
            catch (UnsupportedEncodingException e) {
                throw new OperationFailedException((Throwable)e, new ModelNode().set(LoggingMessages.MESSAGES.failedToSetHandlerEncoding()));
            }
        }
        return this.doApplyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, name, handlerService);
    }

    protected final void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, S handlerService) throws OperationFailedException {
        if (handlerService != null) {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            String name = address.getLastElement().getValue();
            if (CommonAttributes.LEVEL.getName().equals(attributeName)) {
                ((HandlerService)handlerService).setLevel(ModelParser.parseLevel(valueToRestore));
            } else if (CommonAttributes.FILTER.getName().equals(attributeName)) {
                ((HandlerService)handlerService).setFilter(ModelParser.parseFilter(context, valueToRestore));
            } else if (CommonAttributes.FORMATTER.getName().equals(attributeName)) {
                ((HandlerService)handlerService).setFormatterSpec(FormatterSpec.fromModelNode(context, valueToRestore));
            } else if (CommonAttributes.ENCODING.getName().equals(attributeName)) {
                try {
                    ((HandlerService)handlerService).setEncoding(valueToRestore.asString());
                }
                catch (UnsupportedEncodingException e) {
                    throw new OperationFailedException((Throwable)e, new ModelNode().set(LoggingMessages.MESSAGES.failedToSetHandlerEncoding()));
                }
            }
            this.doRevertUpdateToRuntime(context, operation, attributeName, valueToRestore, valueToRevert, name, handlerService);
        }
    }

    protected abstract boolean doApplyUpdateToRuntime(OperationContext var1, ModelNode var2, String var3, ModelNode var4, ModelNode var5, String var6, S var7) throws OperationFailedException;

    protected abstract void doRevertUpdateToRuntime(OperationContext var1, ModelNode var2, String var3, ModelNode var4, ModelNode var5, String var6, S var7) throws OperationFailedException;

    public final AttributeDefinition[] getAttributes() {
        return this.attributes;
    }

    protected static AttributeDefinition[] joinUnique(AttributeDefinition[] supplied, AttributeDefinition ... added) {
        LinkedHashMap<String, AttributeDefinition> result = new LinkedHashMap<String, AttributeDefinition>();
        if (supplied != null) {
            for (AttributeDefinition attr : supplied) {
                result.put(attr.getName(), attr);
            }
        }
        if (added != null) {
            for (AttributeDefinition attr : added) {
                if (result.containsKey(attr.getName())) continue;
                result.put(attr.getName(), attr);
            }
        }
        return result.values().toArray(new AttributeDefinition[result.size()]);
    }
}

