/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.async;

import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.handlers.async.AsyncHandlerService;
import org.jboss.as.logging.handlers.async.AsyncHandlerUnassignSubhandler;
import org.jboss.as.logging.loggers.AbstractLogHandlerAssignmentHandler;
import org.jboss.as.logging.util.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.value.InjectedValue;

public class AsyncHandlerAssignSubhandler
extends AbstractLogHandlerAssignmentHandler {
    public static final String OPERATION_NAME = "assign-subhandler";
    public static final AsyncHandlerAssignSubhandler INSTANCE = new AsyncHandlerAssignSubhandler();

    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CommonAttributes.NAME.validateAndSet(operation, model);
        this.updateHandlersForAssign((AttributeDefinition)CommonAttributes.SUBHANDLERS, operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String asyncHandlerName = address.getLastElement().getValue();
        String handlerNameToAdd = CommonAttributes.NAME.resolveModelAttribute(context, model).asString();
        AsyncHandlerAssignSubhandler.addHandler(context, asyncHandlerName, handlerNameToAdd);
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, ModelNode model, List<ServiceController<?>> controllers) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        String asyncHandlerName = address.getLastElement().getValue();
        String handlerName = model.get(CommonAttributes.NAME.getName()).asString();
        try {
            AsyncHandlerUnassignSubhandler.removeHandler(context, asyncHandlerName, handlerName);
        }
        catch (OperationFailedException e) {
            LoggingLogger.ROOT_LOGGER.errorRevertingOperation(e, ((Object)((Object)this)).getClass().getSimpleName(), operation.require("operation").asString(), PathAddress.pathAddress((ModelNode)operation.require("address")));
        }
    }

    @Override
    protected String getHandlerName(ModelNode model) throws OperationFailedException {
        return CommonAttributes.NAME.validateOperation(model).asString();
    }

    public static void addHandler(OperationContext context, String asyncHandlerName, String handlerNameToAdd) throws OperationFailedException {
        if (asyncHandlerName.equals(handlerNameToAdd)) {
            throw AsyncHandlerAssignSubhandler.createFailureMessage(LoggingMessages.MESSAGES.cannotAddHandlerToSelf(asyncHandlerName));
        }
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController asyncHandlerController = serviceRegistry.getService(LogServices.handlerName(asyncHandlerName));
        ServiceController handlerToAssignController = serviceRegistry.getService(LogServices.handlerName(handlerNameToAdd));
        if (handlerToAssignController == null) {
            throw AsyncHandlerAssignSubhandler.createFailureMessage(LoggingMessages.MESSAGES.handlerNotFound(handlerNameToAdd));
        }
        AsyncHandlerService service = (AsyncHandlerService)AsyncHandlerService.class.cast(asyncHandlerController.getService());
        InjectedValue injectedHandler = new InjectedValue();
        injectedHandler.inject(handlerToAssignController.getValue());
        service.addHandler((InjectedValue<Handler>)injectedHandler);
    }

    public static void addHandlers(AttributeDefinition attribute, ModelNode node, OperationContext context, String asyncHandlerName) throws OperationFailedException {
        ModelNode handlers = attribute.resolveModelAttribute(context, node);
        if (handlers.isDefined() && handlers.getType() == ModelType.LIST) {
            for (ModelNode handler : handlers.asList()) {
                AsyncHandlerAssignSubhandler.addHandler(context, asyncHandlerName, handler.asString());
            }
        }
    }
}

