/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.handlers.file;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.handlers.file.AbstractFileHandlerWriteAttributeHandler;
import org.jboss.as.logging.handlers.file.SizeRotatingFileHandlerService;
import org.jboss.as.logging.util.ModelParser;
import org.jboss.dmr.ModelNode;

public class SizeRotatingHandlerWriteAttributeHandler
extends AbstractFileHandlerWriteAttributeHandler<SizeRotatingFileHandlerService> {
    public static final SizeRotatingHandlerWriteAttributeHandler INSTANCE = new SizeRotatingHandlerWriteAttributeHandler();

    private SizeRotatingHandlerWriteAttributeHandler() {
        super(new AttributeDefinition[]{CommonAttributes.MAX_BACKUP_INDEX, CommonAttributes.ROTATE_SIZE});
    }

    @Override
    protected boolean doApplyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, String handlerName, SizeRotatingFileHandlerService handlerService) throws OperationFailedException {
        boolean result = super.doApplyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, handlerName, handlerService);
        if (CommonAttributes.MAX_BACKUP_INDEX.getName().equals(attributeName)) {
            handlerService.setMaxBackupIndex(resolvedValue.asInt());
            result = false;
        } else if (CommonAttributes.ROTATE_SIZE.getName().equals(attributeName)) {
            handlerService.setRotateSize(ModelParser.parseSize(resolvedValue));
            result = false;
        }
        return result;
    }

    @Override
    protected void doRevertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert, String handlerName, SizeRotatingFileHandlerService handlerService) throws OperationFailedException {
        super.doRevertUpdateToRuntime(context, operation, attributeName, valueToRestore, valueToRevert, handlerName, handlerService);
        if (CommonAttributes.MAX_BACKUP_INDEX.getName().equals(attributeName)) {
            handlerService.setMaxBackupIndex(valueToRestore.asInt());
        } else if (CommonAttributes.ROTATE_SIZE.getName().equals(attributeName)) {
            handlerService.setRotateSize(ModelParser.parseSize(valueToRestore));
        }
    }
}

