/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jtype;

import com.googlecode.jtype.ClassSerializer;
import com.googlecode.jtype.ClassSerializers;
import com.googlecode.jtype.TypeUtils;
import com.googlecode.jtype.Utils;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;

class DefaultGenericArrayType
implements GenericArrayType {
    private final Type componentType;

    public DefaultGenericArrayType(Type componentType) {
        this.componentType = Utils.checkNotNull(componentType, "componentType");
    }

    @Override
    public Type getGenericComponentType() {
        return this.componentType;
    }

    public int hashCode() {
        return this.componentType.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof GenericArrayType)) {
            return false;
        }
        GenericArrayType type = (GenericArrayType)object;
        return this.componentType.equals(type.getGenericComponentType());
    }

    public String toString() {
        return DefaultGenericArrayType.toString(this);
    }

    public static String toString(GenericArrayType type) {
        return DefaultGenericArrayType.toString(type, ClassSerializers.QUALIFIED);
    }

    public static String toString(GenericArrayType type, ClassSerializer serializer) {
        return TypeUtils.toString(type.getGenericComponentType(), serializer) + "[]";
    }
}

