/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.util;

import java.util.Enumeration;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.FacesContext;
import javax.portlet.PortletRequest;
import org.jboss.portletbridge.util.ParameterFunction;

public class PublicParameterUtil {
    private PublicParameterUtil() {
    }

    public static boolean processPublicParameters(FacesContext facesContext, PortletRequest request, Map<String, String> publicParameterMapping, Enumeration<String> parameterNames, ParameterFunction function, String portletName) {
        boolean valueChanged = false;
        ExpressionFactory expressionFactory = facesContext.getApplication().getExpressionFactory();
        ELContext elContext = facesContext.getELContext();
        StringBuilder prefixedName = new StringBuilder(portletName).append(':');
        int preffixLength = prefixedName.length();
        Map publicParameters = request.getPublicParameterMap();
        while (parameterNames.hasMoreElements()) {
            String name = parameterNames.nextElement();
            String mappingEl = publicParameterMapping.get(name);
            if (null == mappingEl) {
                prefixedName.setLength(preffixLength);
                mappingEl = publicParameterMapping.get(prefixedName.append(name).toString());
            }
            if (null == mappingEl) continue;
            ValueExpression valueExpression = expressionFactory.createValueExpression(elContext, mappingEl, Object.class);
            valueChanged = function.processParameter(elContext, publicParameters, name, valueExpression) ? true : valueChanged;
        }
        return valueChanged;
    }
}

