/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.richfaces.application.resource;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.portlet.faces.BridgeUtil;
import org.jboss.portletbridge.application.resource.PortletResourceHandler;
import org.jboss.portletbridge.bridge.logger.BridgeLogger;
import org.jboss.portletbridge.bridge.logger.JULLoggerImpl;
import org.jboss.portletbridge.richfaces.application.resource.RichFacesPortletResource;

public class RichFacesPortletResourceHandler
extends PortletResourceHandler {
    private static final BridgeLogger logger = new JULLoggerImpl(RichFacesPortletResourceHandler.class.getName());
    private final ResourceHandler wrapped;

    public RichFacesPortletResourceHandler(ResourceHandler resourceHandler) {
        super(resourceHandler);
        this.wrapped = resourceHandler;
    }

    public ResourceHandler getWrapped() {
        return this.wrapped;
    }

    public void handleResourceRequest(FacesContext context) throws IOException {
        if (BridgeUtil.isPortletRequest()) {
            ExternalContext externalContext = context.getExternalContext();
            String resourceName = (String)externalContext.getRequestParameterMap().get("/javax.faces.resource".substring(1));
            if (null != resourceName) {
                String libraryId = (String)externalContext.getRequestParameterMap().get("ln");
                ResourceHandler handler = context.getApplication().getResourceHandler();
                Object resource = handler.createResource(resourceName, libraryId);
                if (null != resource) {
                    if (!this.isRichFacesPortletResource((Resource)resource)) {
                        resource = new RichFacesPortletResource((Resource)resource);
                    }
                    this.handleResourceRequest(context, (Resource)resource);
                } else {
                    this.send404(context, resourceName, libraryId);
                }
            } else {
                this.send404(context, resourceName, null);
            }
        } else {
            this.wrapped.handleResourceRequest(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleResourceRequest(FacesContext context, Resource resource) throws IOException {
        if (resource.userAgentNeedsUpdate(context)) {
            ExternalContext extContext = context.getExternalContext();
            ReadableByteChannel resourceChannel = null;
            Channel out = null;
            InputStream in = null;
            int bufferSize = extContext.getResponseBufferSize();
            if (0 == bufferSize) {
                bufferSize = 2048;
            }
            ByteBuffer buf = ByteBuffer.allocate(bufferSize);
            extContext.setResponseBufferSize(buf.capacity());
            try {
                in = resource.getInputStream();
                if (in == null) {
                    this.send404(context, resource.getResourceName(), resource.getLibraryName());
                    return;
                }
                resourceChannel = Channels.newChannel(in);
                String contentType = resource.getContentType();
                if (contentType != null) {
                    extContext.setResponseContentType(resource.getContentType());
                }
                ByteArrayOutputStream byteArray = new ByteArrayOutputStream(bufferSize);
                out = Channels.newChannel(byteArray);
                extContext.setResponseBufferSize(buf.capacity());
                this.handleHeaders(context, resource);
                int size = 0;
                int thisRead = resourceChannel.read(buf);
                int totalWritten = 0;
                while (thisRead != -1) {
                    buf.rewind();
                    buf.limit(thisRead);
                    while ((totalWritten += out.write(buf)) < size) {
                    }
                    buf.clear();
                    size += thisRead;
                    thisRead = resourceChannel.read(buf);
                }
                if (resource.getResourceName().indexOf(".css") > 0) {
                    String updatedCss = this.updateCssUrls(context, byteArray.toString());
                    size = updatedCss.length();
                    byteArray = new ByteArrayOutputStream(size);
                    byteArray.write(updatedCss.getBytes());
                }
                extContext.setResponseContentLength(size);
                extContext.setResponseStatus(200);
                byteArray.writeTo(extContext.getResponseOutputStream());
                byteArray.flush();
                byteArray.close();
            }
            finally {
                if (null != in) {
                    in.close();
                }
                if (null != out) {
                    out.close();
                }
                if (null != resourceChannel) {
                    resourceChannel.close();
                }
            }
        } else {
            this.send304(context);
        }
    }

    protected String updateCssUrls(FacesContext context, String cssContent) {
        HashMap<String, String> urlCache = new HashMap<String, String>();
        ResourceHandler handler = context.getApplication().getResourceHandler();
        for (RichFacesUrlType rfUrlType : RichFacesUrlType.values()) {
            int urlStart = cssContent.indexOf(rfUrlType.getPathPrefix());
            while (urlStart > 0) {
                int fileNamePosStart = urlStart + rfUrlType.getPathPrefix().length();
                int period = cssContent.indexOf(46, fileNamePosStart);
                if (period > 0) {
                    int extEnd = cssContent.indexOf(41, period + 1);
                    String relPath = cssContent.substring(urlStart, extEnd);
                    String imageUrl = (String)urlCache.get(relPath);
                    if (null == imageUrl) {
                        String libraryName;
                        String resourceName = cssContent.substring(fileNamePosStart, extEnd);
                        Object imageResource = handler.createResource(resourceName, libraryName = rfUrlType.getLibraryName());
                        if (!this.isRichFacesPortletResource((Resource)imageResource)) {
                            imageResource = new RichFacesPortletResource((Resource)imageResource);
                        }
                        if (null != imageResource) {
                            imageUrl = imageResource.getRequestPath();
                            imageUrl = imageUrl.replaceAll(libraryName, rfUrlType.getToken());
                            urlCache.put(relPath, imageUrl);
                        } else {
                            imageUrl = relPath;
                            logger.log(BridgeLogger.Level.ERROR, "Unable to retrieve resource " + resourceName + " from library " + libraryName);
                        }
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append(cssContent.substring(0, urlStart));
                    buf.append(imageUrl);
                    buf.append(cssContent.substring(extEnd));
                    cssContent = buf.toString();
                }
                urlStart = cssContent.indexOf(rfUrlType.getPathPrefix(), fileNamePosStart);
            }
        }
        for (RichFacesUrlType rfUrlType : RichFacesUrlType.values()) {
            cssContent = cssContent.replaceAll(rfUrlType.getToken(), rfUrlType.getLibraryName());
        }
        return cssContent;
    }

    protected boolean isRichFacesPortletResource(Resource res) {
        return null == res || res instanceof RichFacesPortletResource;
    }

    protected static enum RichFacesUrlType {
        ONE("org.richfaces", "../../org.richfaces.images/", "rf-one"),
        TWO("org.richfaces", "../../", "rf-two"),
        THREE("org.richfaces.images", "../org.richfaces.images/", "rf-three"),
        FOUR("org.richfaces.images", "org.richfaces.images/", "rf-four");

        private String libraryName;
        private String pathPrefix;
        private String token;

        private RichFacesUrlType(String libraryName, String pathPrefix, String token) {
            this.libraryName = libraryName;
            this.pathPrefix = pathPrefix;
            this.token = token;
        }

        public String getLibraryName() {
            return this.libraryName;
        }

        public String getPathPrefix() {
            return this.pathPrefix;
        }

        public String getToken() {
            return this.token;
        }
    }
}

