/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.client;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import org.jboss.ejb.client.Affinity;
import org.jboss.marshalling.FieldSetter;

public abstract class EJBLocator<T>
implements Serializable {
    private static final long serialVersionUID = -7306257085240447972L;
    private final Class<T> viewType;
    private final String appName;
    private final String moduleName;
    private final String beanName;
    private final String distinctName;
    private final Affinity affinity;
    private final transient Class<? extends T> proxyClass;
    private final transient Constructor<? extends T> proxyConstructor;
    private final transient int hashCode;
    private static final FieldSetter hashCodeSetter = FieldSetter.get(EJBLocator.class, "hashCode");
    private static final FieldSetter proxyClassSetter = FieldSetter.get(EJBLocator.class, "proxyClass");
    private static final FieldSetter proxyConstructorSetter = FieldSetter.get(EJBLocator.class, "proxyConstructor");

    EJBLocator(Class<T> viewType, String appName, String moduleName, String beanName, String distinctName, Affinity affinity) {
        if (viewType == null) {
            throw new IllegalArgumentException("viewType is null");
        }
        if (appName == null) {
            throw new IllegalArgumentException("appName is null");
        }
        if (moduleName == null) {
            throw new IllegalArgumentException("moduleName is null");
        }
        if (beanName == null) {
            throw new IllegalArgumentException("beanName is null");
        }
        if (distinctName == null) {
            throw new IllegalArgumentException("distinctName is null");
        }
        this.viewType = viewType;
        this.appName = appName;
        this.moduleName = moduleName;
        this.beanName = beanName;
        this.distinctName = distinctName;
        this.affinity = affinity == null ? Affinity.NONE : affinity;
        this.proxyClass = Proxy.getProxyClass(viewType.getClassLoader(), viewType).asSubclass(viewType);
        try {
            this.proxyConstructor = this.proxyClass.getConstructor(InvocationHandler.class);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError("No valid constructor found on proxy class");
        }
        this.hashCode = EJBLocator.calcHashCode(viewType, appName, moduleName, beanName, distinctName);
    }

    private static int calcHashCode(Class<?> viewType, String appName, String moduleName, String beanName, String distinctName) {
        return viewType.hashCode() * 13 + (appName.hashCode() * 13 + (moduleName.hashCode() * 13 + (beanName.hashCode() * 13 + distinctName.hashCode())));
    }

    public Class<T> getViewType() {
        return this.viewType;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getDistinctName() {
        return this.distinctName;
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object other) {
        return other instanceof EJBLocator && this.equals((EJBLocator)other);
    }

    public Class<? extends T> getProxyClass() {
        return this.proxyClass;
    }

    public Constructor<? extends T> getProxyConstructor() {
        return this.proxyConstructor;
    }

    public T createProxyInstance(InvocationHandler invocationHandler) {
        if (invocationHandler == null) {
            throw new IllegalArgumentException("invocationHandler is null");
        }
        try {
            return this.proxyConstructor.newInstance(invocationHandler);
        }
        catch (InstantiationException e) {
            throw new InstantiationError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new UndeclaredThrowableException(e.getCause());
        }
    }

    public boolean equals(EJBLocator<?> other) {
        return this == other || other != null && this.hashCode == other.hashCode && this.appName.equals(other.appName) && this.moduleName.equals(other.moduleName) && this.beanName.equals(other.beanName) && this.distinctName.equals(other.distinctName);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        Constructor<T> proxyConstructor;
        ois.defaultReadObject();
        Class<T> proxyType = Proxy.getProxyClass(this.viewType.getClassLoader(), this.viewType).asSubclass(this.viewType);
        try {
            proxyConstructor = proxyType.getConstructor(InvocationHandler.class);
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError("No valid constructor found on proxy class");
        }
        proxyClassSetter.set(this, proxyType);
        proxyConstructorSetter.set(this, proxyConstructor);
        hashCodeSetter.setInt(this, EJBLocator.calcHashCode(this.viewType, this.appName, this.moduleName, this.beanName, this.distinctName));
    }
}

